/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import io.neba.spring.mvc.MultipartSlingHttpServletRequest;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class SlingMultipartResolver
implements MultipartResolver {
    public boolean isMultipart(@Nonnull HttpServletRequest request) {
        return request != null && SlingMultipartResolver.isMultipartContent(request);
    }

    @Nonnull
    public MultipartHttpServletRequest resolveMultipart(@Nonnull HttpServletRequest request) throws MultipartException {
        if (request == null) {
            throw new IllegalArgumentException("Method argument request must not be null.");
        }
        if (!(request instanceof SlingHttpServletRequest)) {
            throw new IllegalArgumentException("Method argument request must be a " + SlingHttpServletRequest.class + ", but is a " + request.getClass() + ".");
        }
        return new MultipartSlingHttpServletRequest((SlingHttpServletRequest)request);
    }

    public void cleanupMultipart(@Nonnull MultipartHttpServletRequest request) {
    }

    private static boolean isMultipartContent(HttpServletRequest request) {
        return StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)"POST") && StringUtils.startsWithIgnoreCase((CharSequence)request.getContentType(), (CharSequence)"multipart/");
    }
}

