/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.blueprint;

import io.neba.spring.blueprint.ContextShutdownHandler;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextEvent;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextListener;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleContextFailedEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="osgiApplicationContextListener")
public class ContextFailedHandler
extends ContextShutdownHandler
implements OsgiBundleApplicationContextListener<OsgiBundleApplicationContextEvent> {
    @Async
    public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
        if (event instanceof OsgiBundleContextFailedEvent) {
            Bundle bundle = event.getBundle();
            this.handleStop(bundle);
            this.stop(bundle);
        }
    }

    private void stop(Bundle bundle) {
        try {
            if (this.canStop(bundle)) {
                bundle.stop(1);
            }
        }
        catch (BundleException e) {
            throw new RuntimeException("Unable to stop bundle " + bundle.getSymbolicName() + ".", e);
        }
    }

    private boolean canStop(Bundle bundle) {
        return bundle.getState() == 32 || bundle.getState() == 8;
    }
}

