/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.mapper.fn;

import io.mybatis.mapper.fn.Reflections;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityFactory;
import io.mybatis.provider.EntityTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Fn<T, R>
extends Function<T, R>,
Serializable {
    public static final Map<Fn, EntityColumn> FN_COLUMN_MAP = new HashMap<Fn, EntityColumn>();

    public static <E> Fns<E> of(Fn<E, Object> ... fns) {
        return new Fns((Fn[])fns);
    }

    public static <E> Fns<E> of(Class<E> entityClass, String ... columnNames) {
        EntityTable entityTable = EntityFactory.create(entityClass);
        Set columnNameSet = Arrays.stream(columnNames).collect(Collectors.toSet());
        List columns = entityTable.columns().stream().filter(column -> columnNameSet.contains(column.property())).collect(Collectors.toList());
        return new Fns(entityClass, entityTable.table(), columns);
    }

    default public String toField() {
        return Reflections.fnToFieldName(this).getField();
    }

    default public String toColumn() {
        return this.toEntityColumn().column();
    }

    default public EntityColumn toEntityColumn() {
        if (!FN_COLUMN_MAP.containsKey(this)) {
            Reflections.ClassField classField = Reflections.fnToFieldName(this);
            EntityColumn entityColumn = EntityFactory.create(classField.getClazz()).columns().stream().filter(column -> column.property().equals(classField.getField())).findFirst().orElseThrow(() -> new RuntimeException(classField.getField() + " does not mark database column field annotations, unable to obtain column information"));
            FN_COLUMN_MAP.put(this, entityColumn);
        }
        return FN_COLUMN_MAP.get(this);
    }

    public static class Fns<E>
    extends EntityTable {
        private Fns(Class<E> entityClass, String table, List<EntityColumn> columns) {
            super(entityClass);
            this.table = table;
            this.columns = columns;
        }

        private Fns(Fn<E, Object> ... fns) {
            super(null);
            this.columns = new ArrayList(fns.length);
            for (int i = 0; i < fns.length; ++i) {
                this.columns.add(fns[i].toEntityColumn());
                if (i != 0) continue;
                EntityTable entityTable = ((EntityColumn)this.columns.get(i)).entityTable();
                this.table = entityTable.table();
                this.entityClass = entityTable.entityClass();
                this.resultMap = entityTable.resultMap();
                this.autoResultMap = entityTable.autoResultMap();
            }
        }

        public boolean isNotEmpty() {
            return !this.columns().isEmpty();
        }
    }
}

