/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.stream.Stream;

public final class Globals {
    
    private final Map<String, String> queryParams = new HashMap<>();
    private final Map<String, String> pathParams = new HashMap<>();
    private final Map<String, String> headerParams = new HashMap<>();
    

    public Globals() {
    }
    
    // internal use only
    public void putParam(String type, String name, Object value) {
        if ("pathParam".equals(type)) {
            putPathParam(name, value);
        } else if ("queryParam".equals(type)) {
            putQueryParam(name, value);
        } else if ("header".equals(type)) {
            putHeader(name, value);
        } else {
            throw new IllegalArgumentException("Unknown parameter type: " + type);
        }
    }
    
    // internal use only
    public Optional<String> getParam(String type, String name) {
        if ("pathParam".equals(type)){
            return getPathParam(name);
        } else if ("queryParam".equals(type)) {
           return getQueryParam(name);
        } else if ("header".equals(type)) {
           return getHeader(name);
        } else {
            throw new IllegalArgumentException("Unknown parameter type: " + type);
        }
    }    

    public void putQueryParam(String name, Object value) {
        if (value != null) {
            queryParams.put(name, Utils.valToString(value));
        }
    }

    public void putPathParam(String name, Object value) {
        if (value != null) {
            pathParams.put(name, Utils.valToString(value));
        }
    }

    public void putHeader(String name, Object value) {
        if (value != null) {
            headerParams.put(name, Utils.valToString(value));
        }
    }

    public Optional<String> getQueryParam(String name) {
        return Optional.ofNullable(queryParams.get(name));      
    }
   
    public Optional<String> getPathParam(String name) {
        return Optional.ofNullable(pathParams.get(name));
    }

    public Optional<String> getHeader(String name) {
        return Optional.ofNullable(headerParams.get(name));
    }
    
    public Stream<Entry<String, String>> queryParamsAsStream() {
        return queryParams.entrySet().stream();
    }
    
    public Stream<Entry<String, String>> pathParamsAsStream() {
        return pathParams.entrySet().stream();
    }

    public Stream<Entry<String, String>> headerParamsAsStream() {
        return headerParams.entrySet().stream();
    }
}
