/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.utils;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.io.IOException;
import java.io.UncheckedIOException;

public class Exceptions {
    public static Exception coerceException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception) throwable;
        }

        return new Exception(throwable);
    }

    public static RuntimeException unchecked(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException) t;
        } else if (t instanceof Error) {
            throw (Error) t;  // propagate JVM-level errors properly
        } else if (t instanceof IOException) {
            throw new UncheckedIOException((IOException) t);
        } else {
           throw new RuntimeException(t);
        }
    }

    public static <T> T rethrow(Throwable e) {
        throw unchecked(e);
    }

    @FunctionalInterface
    public interface CheckedFunction<T, R> {
        R apply(T t) throws Exception;
    }

    @FunctionalInterface
    public interface CheckedSupplier<T> {
        T get() throws Exception;
    }

    @FunctionalInterface
    public interface CheckedConsumer<T> {
        void accept(T t) throws Exception;
    }

    @FunctionalInterface
    public interface CheckedRunnable {
        void run() throws Exception;
    }

    public static <T, R> Function<T, R> unchecked(CheckedFunction<T, R> fn) {
        return t -> {
            try {
                return fn.apply(t);
            } catch (Exception e) {
                throw unchecked(e);
            }
        };
    }

    public static <T> Supplier<T> unchecked(CheckedSupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            } catch (Exception e) {
                throw unchecked(e);
            }
        };
    }

    public static <T> Consumer<T> unchecked(CheckedConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            } catch (Exception e) {
                throw unchecked(e);
            }
        };
    }

    public static Runnable unchecked(CheckedRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            } catch (Exception e) {
                throw unchecked(e);
            }
        };
    }
}
