/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdateUnderwriting;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpsertUnderwritingRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateUnderwriting updateUnderwriting;

    @JsonCreator
    public UpsertUnderwritingRequest(
            String accountID,
            UpdateUnderwriting updateUnderwriting) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(updateUnderwriting, "updateUnderwriting");
        this.accountID = accountID;
        this.updateUnderwriting = updateUnderwriting;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public UpdateUnderwriting updateUnderwriting() {
        return updateUnderwriting;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpsertUnderwritingRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpsertUnderwritingRequest withUpdateUnderwriting(UpdateUnderwriting updateUnderwriting) {
        Utils.checkNotNull(updateUnderwriting, "updateUnderwriting");
        this.updateUnderwriting = updateUnderwriting;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpsertUnderwritingRequest other = (UpsertUnderwritingRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.updateUnderwriting, other.updateUnderwriting);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, updateUnderwriting);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpsertUnderwritingRequest.class,
                "accountID", accountID,
                "updateUnderwriting", updateUnderwriting);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private UpdateUnderwriting updateUnderwriting;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder updateUnderwriting(UpdateUnderwriting updateUnderwriting) {
            Utils.checkNotNull(updateUnderwriting, "updateUnderwriting");
            this.updateUnderwriting = updateUnderwriting;
            return this;
        }

        public UpsertUnderwritingRequest build() {

            return new UpsertUnderwritingRequest(
                accountID, updateUnderwriting);
        }

    }
}
