/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.BrandProperties;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpsertBrandRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private BrandProperties brandProperties;

    @JsonCreator
    public UpsertBrandRequest(
            String accountID,
            BrandProperties brandProperties) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(brandProperties, "brandProperties");
        this.accountID = accountID;
        this.brandProperties = brandProperties;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public BrandProperties brandProperties() {
        return brandProperties;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpsertBrandRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpsertBrandRequest withBrandProperties(BrandProperties brandProperties) {
        Utils.checkNotNull(brandProperties, "brandProperties");
        this.brandProperties = brandProperties;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpsertBrandRequest other = (UpsertBrandRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.brandProperties, other.brandProperties);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, brandProperties);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpsertBrandRequest.class,
                "accountID", accountID,
                "brandProperties", brandProperties);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private BrandProperties brandProperties;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder brandProperties(BrandProperties brandProperties) {
            Utils.checkNotNull(brandProperties, "brandProperties");
            this.brandProperties = brandProperties;
            return this;
        }

        public UpsertBrandRequest build() {

            return new UpsertBrandRequest(
                accountID, brandProperties);
        }

    }
}
