/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.FileUploadRequestMultiPart;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UploadFileRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=multipart/form-data")
    private FileUploadRequestMultiPart fileUploadRequestMultiPart;

    @JsonCreator
    public UploadFileRequest(
            String accountID,
            FileUploadRequestMultiPart fileUploadRequestMultiPart) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(fileUploadRequestMultiPart, "fileUploadRequestMultiPart");
        this.accountID = accountID;
        this.fileUploadRequestMultiPart = fileUploadRequestMultiPart;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public FileUploadRequestMultiPart fileUploadRequestMultiPart() {
        return fileUploadRequestMultiPart;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UploadFileRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UploadFileRequest withFileUploadRequestMultiPart(FileUploadRequestMultiPart fileUploadRequestMultiPart) {
        Utils.checkNotNull(fileUploadRequestMultiPart, "fileUploadRequestMultiPart");
        this.fileUploadRequestMultiPart = fileUploadRequestMultiPart;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UploadFileRequest other = (UploadFileRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.fileUploadRequestMultiPart, other.fileUploadRequestMultiPart);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, fileUploadRequestMultiPart);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UploadFileRequest.class,
                "accountID", accountID,
                "fileUploadRequestMultiPart", fileUploadRequestMultiPart);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private FileUploadRequestMultiPart fileUploadRequestMultiPart;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder fileUploadRequestMultiPart(FileUploadRequestMultiPart fileUploadRequestMultiPart) {
            Utils.checkNotNull(fileUploadRequestMultiPart, "fileUploadRequestMultiPart");
            this.fileUploadRequestMultiPart = fileUploadRequestMultiPart;
            return this;
        }

        public UploadFileRequest build() {

            return new UploadFileRequest(
                accountID, fileUploadRequestMultiPart);
        }

    }
}
