/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateEvidenceText;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UploadDisputeEvidenceTextRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=disputeID")
    private String disputeID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private CreateEvidenceText createEvidenceText;

    @JsonCreator
    public UploadDisputeEvidenceTextRequest(
            String accountID,
            String disputeID,
            CreateEvidenceText createEvidenceText) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(createEvidenceText, "createEvidenceText");
        this.accountID = accountID;
        this.disputeID = disputeID;
        this.createEvidenceText = createEvidenceText;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    @JsonIgnore
    public CreateEvidenceText createEvidenceText() {
        return createEvidenceText;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UploadDisputeEvidenceTextRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UploadDisputeEvidenceTextRequest withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    public UploadDisputeEvidenceTextRequest withCreateEvidenceText(CreateEvidenceText createEvidenceText) {
        Utils.checkNotNull(createEvidenceText, "createEvidenceText");
        this.createEvidenceText = createEvidenceText;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UploadDisputeEvidenceTextRequest other = (UploadDisputeEvidenceTextRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID) &&
            Utils.enhancedDeepEquals(this.createEvidenceText, other.createEvidenceText);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, disputeID, createEvidenceText);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UploadDisputeEvidenceTextRequest.class,
                "accountID", accountID,
                "disputeID", disputeID,
                "createEvidenceText", createEvidenceText);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String disputeID;

        private CreateEvidenceText createEvidenceText;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }


        public Builder createEvidenceText(CreateEvidenceText createEvidenceText) {
            Utils.checkNotNull(createEvidenceText, "createEvidenceText");
            this.createEvidenceText = createEvidenceText;
            return this;
        }

        public UploadDisputeEvidenceTextRequest build() {

            return new UploadDisputeEvidenceTextRequest(
                accountID, disputeID, createEvidenceText);
        }

    }
}
