/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateEvidenceFileMultiPart;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UploadDisputeEvidenceFileRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=disputeID")
    private String disputeID;


    @SpeakeasyMetadata("request:mediaType=multipart/form-data")
    private CreateEvidenceFileMultiPart createEvidenceFileMultiPart;

    @JsonCreator
    public UploadDisputeEvidenceFileRequest(
            String accountID,
            String disputeID,
            CreateEvidenceFileMultiPart createEvidenceFileMultiPart) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(createEvidenceFileMultiPart, "createEvidenceFileMultiPart");
        this.accountID = accountID;
        this.disputeID = disputeID;
        this.createEvidenceFileMultiPart = createEvidenceFileMultiPart;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    @JsonIgnore
    public CreateEvidenceFileMultiPart createEvidenceFileMultiPart() {
        return createEvidenceFileMultiPart;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UploadDisputeEvidenceFileRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UploadDisputeEvidenceFileRequest withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    public UploadDisputeEvidenceFileRequest withCreateEvidenceFileMultiPart(CreateEvidenceFileMultiPart createEvidenceFileMultiPart) {
        Utils.checkNotNull(createEvidenceFileMultiPart, "createEvidenceFileMultiPart");
        this.createEvidenceFileMultiPart = createEvidenceFileMultiPart;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UploadDisputeEvidenceFileRequest other = (UploadDisputeEvidenceFileRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID) &&
            Utils.enhancedDeepEquals(this.createEvidenceFileMultiPart, other.createEvidenceFileMultiPart);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, disputeID, createEvidenceFileMultiPart);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UploadDisputeEvidenceFileRequest.class,
                "accountID", accountID,
                "disputeID", disputeID,
                "createEvidenceFileMultiPart", createEvidenceFileMultiPart);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String disputeID;

        private CreateEvidenceFileMultiPart createEvidenceFileMultiPart;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }


        public Builder createEvidenceFileMultiPart(CreateEvidenceFileMultiPart createEvidenceFileMultiPart) {
            Utils.checkNotNull(createEvidenceFileMultiPart, "createEvidenceFileMultiPart");
            this.createEvidenceFileMultiPart = createEvidenceFileMultiPart;
            return this;
        }

        public UploadDisputeEvidenceFileRequest build() {

            return new UploadDisputeEvidenceFileRequest(
                accountID, disputeID, createEvidenceFileMultiPart);
        }

    }
}
