/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.PatchTransfer;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateTransferRequest {
    /**
     * Identifier for the transfer.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=transferID")
    private String transferID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private PatchTransfer patchTransfer;

    @JsonCreator
    public UpdateTransferRequest(
            String transferID,
            String accountID,
            PatchTransfer patchTransfer) {
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(patchTransfer, "patchTransfer");
        this.transferID = transferID;
        this.accountID = accountID;
        this.patchTransfer = patchTransfer;
    }

    /**
     * Identifier for the transfer.
     */
    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public PatchTransfer patchTransfer() {
        return patchTransfer;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Identifier for the transfer.
     */
    public UpdateTransferRequest withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public UpdateTransferRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateTransferRequest withPatchTransfer(PatchTransfer patchTransfer) {
        Utils.checkNotNull(patchTransfer, "patchTransfer");
        this.patchTransfer = patchTransfer;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateTransferRequest other = (UpdateTransferRequest) o;
        return 
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.patchTransfer, other.patchTransfer);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            transferID, accountID, patchTransfer);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateTransferRequest.class,
                "transferID", transferID,
                "accountID", accountID,
                "patchTransfer", patchTransfer);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String transferID;

        private String accountID;

        private PatchTransfer patchTransfer;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Identifier for the transfer.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder patchTransfer(PatchTransfer patchTransfer) {
            Utils.checkNotNull(patchTransfer, "patchTransfer");
            this.patchTransfer = patchTransfer;
            return this;
        }

        public UpdateTransferRequest build() {

            return new UpdateTransferRequest(
                transferID, accountID, patchTransfer);
        }

    }
}
