/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdateTicket;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateTicketRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=ticketID")
    private String ticketID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateTicket updateTicket;

    @JsonCreator
    public UpdateTicketRequest(
            String accountID,
            String ticketID,
            UpdateTicket updateTicket) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(ticketID, "ticketID");
        Utils.checkNotNull(updateTicket, "updateTicket");
        this.accountID = accountID;
        this.ticketID = ticketID;
        this.updateTicket = updateTicket;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String ticketID() {
        return ticketID;
    }

    @JsonIgnore
    public UpdateTicket updateTicket() {
        return updateTicket;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateTicketRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateTicketRequest withTicketID(String ticketID) {
        Utils.checkNotNull(ticketID, "ticketID");
        this.ticketID = ticketID;
        return this;
    }

    public UpdateTicketRequest withUpdateTicket(UpdateTicket updateTicket) {
        Utils.checkNotNull(updateTicket, "updateTicket");
        this.updateTicket = updateTicket;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateTicketRequest other = (UpdateTicketRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.ticketID, other.ticketID) &&
            Utils.enhancedDeepEquals(this.updateTicket, other.updateTicket);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, ticketID, updateTicket);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateTicketRequest.class,
                "accountID", accountID,
                "ticketID", ticketID,
                "updateTicket", updateTicket);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String ticketID;

        private UpdateTicket updateTicket;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder ticketID(String ticketID) {
            Utils.checkNotNull(ticketID, "ticketID");
            this.ticketID = ticketID;
            return this;
        }


        public Builder updateTicket(UpdateTicket updateTicket) {
            Utils.checkNotNull(updateTicket, "updateTicket");
            this.updateTicket = updateTicket;
            return this;
        }

        public UpdateTicketRequest build() {

            return new UpdateTicketRequest(
                accountID, ticketID, updateTicket);
        }

    }
}
