/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.PatchSweepConfig;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateSweepConfigRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=sweepConfigID")
    private String sweepConfigID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private PatchSweepConfig patchSweepConfig;

    @JsonCreator
    public UpdateSweepConfigRequest(
            String accountID,
            String sweepConfigID,
            PatchSweepConfig patchSweepConfig) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(sweepConfigID, "sweepConfigID");
        Utils.checkNotNull(patchSweepConfig, "patchSweepConfig");
        this.accountID = accountID;
        this.sweepConfigID = sweepConfigID;
        this.patchSweepConfig = patchSweepConfig;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String sweepConfigID() {
        return sweepConfigID;
    }

    @JsonIgnore
    public PatchSweepConfig patchSweepConfig() {
        return patchSweepConfig;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateSweepConfigRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateSweepConfigRequest withSweepConfigID(String sweepConfigID) {
        Utils.checkNotNull(sweepConfigID, "sweepConfigID");
        this.sweepConfigID = sweepConfigID;
        return this;
    }

    public UpdateSweepConfigRequest withPatchSweepConfig(PatchSweepConfig patchSweepConfig) {
        Utils.checkNotNull(patchSweepConfig, "patchSweepConfig");
        this.patchSweepConfig = patchSweepConfig;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateSweepConfigRequest other = (UpdateSweepConfigRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.sweepConfigID, other.sweepConfigID) &&
            Utils.enhancedDeepEquals(this.patchSweepConfig, other.patchSweepConfig);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, sweepConfigID, patchSweepConfig);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateSweepConfigRequest.class,
                "accountID", accountID,
                "sweepConfigID", sweepConfigID,
                "patchSweepConfig", patchSweepConfig);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String sweepConfigID;

        private PatchSweepConfig patchSweepConfig;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder sweepConfigID(String sweepConfigID) {
            Utils.checkNotNull(sweepConfigID, "sweepConfigID");
            this.sweepConfigID = sweepConfigID;
            return this;
        }


        public Builder patchSweepConfig(PatchSweepConfig patchSweepConfig) {
            Utils.checkNotNull(patchSweepConfig, "patchSweepConfig");
            this.patchSweepConfig = patchSweepConfig;
            return this;
        }

        public UpdateSweepConfigRequest build() {

            return new UpdateSweepConfigRequest(
                accountID, sweepConfigID, patchSweepConfig);
        }

    }
}
