/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpsertSchedule;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateScheduleRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=scheduleID")
    private String scheduleID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpsertSchedule upsertSchedule;

    @JsonCreator
    public UpdateScheduleRequest(
            String accountID,
            String scheduleID,
            UpsertSchedule upsertSchedule) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(scheduleID, "scheduleID");
        Utils.checkNotNull(upsertSchedule, "upsertSchedule");
        this.accountID = accountID;
        this.scheduleID = scheduleID;
        this.upsertSchedule = upsertSchedule;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String scheduleID() {
        return scheduleID;
    }

    @JsonIgnore
    public UpsertSchedule upsertSchedule() {
        return upsertSchedule;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateScheduleRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateScheduleRequest withScheduleID(String scheduleID) {
        Utils.checkNotNull(scheduleID, "scheduleID");
        this.scheduleID = scheduleID;
        return this;
    }

    public UpdateScheduleRequest withUpsertSchedule(UpsertSchedule upsertSchedule) {
        Utils.checkNotNull(upsertSchedule, "upsertSchedule");
        this.upsertSchedule = upsertSchedule;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateScheduleRequest other = (UpdateScheduleRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.scheduleID, other.scheduleID) &&
            Utils.enhancedDeepEquals(this.upsertSchedule, other.upsertSchedule);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, scheduleID, upsertSchedule);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateScheduleRequest.class,
                "accountID", accountID,
                "scheduleID", scheduleID,
                "upsertSchedule", upsertSchedule);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String scheduleID;

        private UpsertSchedule upsertSchedule;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder scheduleID(String scheduleID) {
            Utils.checkNotNull(scheduleID, "scheduleID");
            this.scheduleID = scheduleID;
            return this;
        }


        public Builder upsertSchedule(UpsertSchedule upsertSchedule) {
            Utils.checkNotNull(upsertSchedule, "upsertSchedule");
            this.upsertSchedule = upsertSchedule;
            return this;
        }

        public UpdateScheduleRequest build() {

            return new UpdateScheduleRequest(
                accountID, scheduleID, upsertSchedule);
        }

    }
}
