/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdateRepresentative;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateRepresentativeRequest {
    /**
     * ID of the account.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * ID of the representative.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=representativeID")
    private String representativeID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateRepresentative updateRepresentative;

    @JsonCreator
    public UpdateRepresentativeRequest(
            String accountID,
            String representativeID,
            UpdateRepresentative updateRepresentative) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(representativeID, "representativeID");
        Utils.checkNotNull(updateRepresentative, "updateRepresentative");
        this.accountID = accountID;
        this.representativeID = representativeID;
        this.updateRepresentative = updateRepresentative;
    }

    /**
     * ID of the account.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * ID of the representative.
     */
    @JsonIgnore
    public String representativeID() {
        return representativeID;
    }

    @JsonIgnore
    public UpdateRepresentative updateRepresentative() {
        return updateRepresentative;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the account.
     */
    public UpdateRepresentativeRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * ID of the representative.
     */
    public UpdateRepresentativeRequest withRepresentativeID(String representativeID) {
        Utils.checkNotNull(representativeID, "representativeID");
        this.representativeID = representativeID;
        return this;
    }

    public UpdateRepresentativeRequest withUpdateRepresentative(UpdateRepresentative updateRepresentative) {
        Utils.checkNotNull(updateRepresentative, "updateRepresentative");
        this.updateRepresentative = updateRepresentative;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateRepresentativeRequest other = (UpdateRepresentativeRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.representativeID, other.representativeID) &&
            Utils.enhancedDeepEquals(this.updateRepresentative, other.updateRepresentative);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, representativeID, updateRepresentative);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateRepresentativeRequest.class,
                "accountID", accountID,
                "representativeID", representativeID,
                "updateRepresentative", updateRepresentative);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String representativeID;

        private UpdateRepresentative updateRepresentative;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the account.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * ID of the representative.
         */
        public Builder representativeID(String representativeID) {
            Utils.checkNotNull(representativeID, "representativeID");
            this.representativeID = representativeID;
            return this;
        }


        public Builder updateRepresentative(UpdateRepresentative updateRepresentative) {
            Utils.checkNotNull(updateRepresentative, "updateRepresentative");
            this.updateRepresentative = updateRepresentative;
            return this;
        }

        public UpdateRepresentativeRequest build() {

            return new UpdateRepresentativeRequest(
                accountID, representativeID, updateRepresentative);
        }

    }
}
