/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdatePaymentLink;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdatePaymentLinkRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=paymentLinkCode")
    private String paymentLinkCode;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdatePaymentLink updatePaymentLink;

    @JsonCreator
    public UpdatePaymentLinkRequest(
            String accountID,
            String paymentLinkCode,
            UpdatePaymentLink updatePaymentLink) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(paymentLinkCode, "paymentLinkCode");
        Utils.checkNotNull(updatePaymentLink, "updatePaymentLink");
        this.accountID = accountID;
        this.paymentLinkCode = paymentLinkCode;
        this.updatePaymentLink = updatePaymentLink;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String paymentLinkCode() {
        return paymentLinkCode;
    }

    @JsonIgnore
    public UpdatePaymentLink updatePaymentLink() {
        return updatePaymentLink;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdatePaymentLinkRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdatePaymentLinkRequest withPaymentLinkCode(String paymentLinkCode) {
        Utils.checkNotNull(paymentLinkCode, "paymentLinkCode");
        this.paymentLinkCode = paymentLinkCode;
        return this;
    }

    public UpdatePaymentLinkRequest withUpdatePaymentLink(UpdatePaymentLink updatePaymentLink) {
        Utils.checkNotNull(updatePaymentLink, "updatePaymentLink");
        this.updatePaymentLink = updatePaymentLink;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdatePaymentLinkRequest other = (UpdatePaymentLinkRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.paymentLinkCode, other.paymentLinkCode) &&
            Utils.enhancedDeepEquals(this.updatePaymentLink, other.updatePaymentLink);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, paymentLinkCode, updatePaymentLink);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdatePaymentLinkRequest.class,
                "accountID", accountID,
                "paymentLinkCode", paymentLinkCode,
                "updatePaymentLink", updatePaymentLink);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String paymentLinkCode;

        private UpdatePaymentLink updatePaymentLink;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder paymentLinkCode(String paymentLinkCode) {
            Utils.checkNotNull(paymentLinkCode, "paymentLinkCode");
            this.paymentLinkCode = paymentLinkCode;
            return this;
        }


        public Builder updatePaymentLink(UpdatePaymentLink updatePaymentLink) {
            Utils.checkNotNull(updatePaymentLink, "updatePaymentLink");
            this.updatePaymentLink = updatePaymentLink;
            return this;
        }

        public UpdatePaymentLinkRequest build() {

            return new UpdatePaymentLinkRequest(
                accountID, paymentLinkCode, updatePaymentLink);
        }

    }
}
