/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdateIssuedCard;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateIssuedCardRequest {
    /**
     * The Moov business account for which the card was issued.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=issuedCardID")
    private String issuedCardID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateIssuedCard updateIssuedCard;

    @JsonCreator
    public UpdateIssuedCardRequest(
            String accountID,
            String issuedCardID,
            UpdateIssuedCard updateIssuedCard) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        Utils.checkNotNull(updateIssuedCard, "updateIssuedCard");
        this.accountID = accountID;
        this.issuedCardID = issuedCardID;
        this.updateIssuedCard = updateIssuedCard;
    }

    /**
     * The Moov business account for which the card was issued.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String issuedCardID() {
        return issuedCardID;
    }

    @JsonIgnore
    public UpdateIssuedCard updateIssuedCard() {
        return updateIssuedCard;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The Moov business account for which the card was issued.
     */
    public UpdateIssuedCardRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateIssuedCardRequest withIssuedCardID(String issuedCardID) {
        Utils.checkNotNull(issuedCardID, "issuedCardID");
        this.issuedCardID = issuedCardID;
        return this;
    }

    public UpdateIssuedCardRequest withUpdateIssuedCard(UpdateIssuedCard updateIssuedCard) {
        Utils.checkNotNull(updateIssuedCard, "updateIssuedCard");
        this.updateIssuedCard = updateIssuedCard;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateIssuedCardRequest other = (UpdateIssuedCardRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.issuedCardID, other.issuedCardID) &&
            Utils.enhancedDeepEquals(this.updateIssuedCard, other.updateIssuedCard);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, issuedCardID, updateIssuedCard);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateIssuedCardRequest.class,
                "accountID", accountID,
                "issuedCardID", issuedCardID,
                "updateIssuedCard", updateIssuedCard);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String issuedCardID;

        private UpdateIssuedCard updateIssuedCard;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The Moov business account for which the card was issued.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder issuedCardID(String issuedCardID) {
            Utils.checkNotNull(issuedCardID, "issuedCardID");
            this.issuedCardID = issuedCardID;
            return this;
        }


        public Builder updateIssuedCard(UpdateIssuedCard updateIssuedCard) {
            Utils.checkNotNull(updateIssuedCard, "updateIssuedCard");
            this.updateIssuedCard = updateIssuedCard;
            return this;
        }

        public UpdateIssuedCardRequest build() {

            return new UpdateIssuedCardRequest(
                accountID, issuedCardID, updateIssuedCard);
        }

    }
}
