/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdateEvidence;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateDisputeEvidenceRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=disputeID")
    private String disputeID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=evidenceID")
    private String evidenceID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateEvidence updateEvidence;

    @JsonCreator
    public UpdateDisputeEvidenceRequest(
            String accountID,
            String disputeID,
            String evidenceID,
            UpdateEvidence updateEvidence) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(evidenceID, "evidenceID");
        Utils.checkNotNull(updateEvidence, "updateEvidence");
        this.accountID = accountID;
        this.disputeID = disputeID;
        this.evidenceID = evidenceID;
        this.updateEvidence = updateEvidence;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String disputeID() {
        return disputeID;
    }

    @JsonIgnore
    public String evidenceID() {
        return evidenceID;
    }

    @JsonIgnore
    public UpdateEvidence updateEvidence() {
        return updateEvidence;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateDisputeEvidenceRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateDisputeEvidenceRequest withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    public UpdateDisputeEvidenceRequest withEvidenceID(String evidenceID) {
        Utils.checkNotNull(evidenceID, "evidenceID");
        this.evidenceID = evidenceID;
        return this;
    }

    public UpdateDisputeEvidenceRequest withUpdateEvidence(UpdateEvidence updateEvidence) {
        Utils.checkNotNull(updateEvidence, "updateEvidence");
        this.updateEvidence = updateEvidence;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateDisputeEvidenceRequest other = (UpdateDisputeEvidenceRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID) &&
            Utils.enhancedDeepEquals(this.evidenceID, other.evidenceID) &&
            Utils.enhancedDeepEquals(this.updateEvidence, other.updateEvidence);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, disputeID, evidenceID,
            updateEvidence);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateDisputeEvidenceRequest.class,
                "accountID", accountID,
                "disputeID", disputeID,
                "evidenceID", evidenceID,
                "updateEvidence", updateEvidence);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String disputeID;

        private String evidenceID;

        private UpdateEvidence updateEvidence;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }


        public Builder evidenceID(String evidenceID) {
            Utils.checkNotNull(evidenceID, "evidenceID");
            this.evidenceID = evidenceID;
            return this;
        }


        public Builder updateEvidence(UpdateEvidence updateEvidence) {
            Utils.checkNotNull(updateEvidence, "updateEvidence");
            this.updateEvidence = updateEvidence;
            return this;
        }

        public UpdateDisputeEvidenceRequest build() {

            return new UpdateDisputeEvidenceRequest(
                accountID, disputeID, evidenceID,
                updateEvidence);
        }

    }
}
