/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdateBrand;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateBrandRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateBrand updateBrand;

    @JsonCreator
    public UpdateBrandRequest(
            String accountID,
            UpdateBrand updateBrand) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(updateBrand, "updateBrand");
        this.accountID = accountID;
        this.updateBrand = updateBrand;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public UpdateBrand updateBrand() {
        return updateBrand;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateBrandRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateBrandRequest withUpdateBrand(UpdateBrand updateBrand) {
        Utils.checkNotNull(updateBrand, "updateBrand");
        this.updateBrand = updateBrand;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateBrandRequest other = (UpdateBrandRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.updateBrand, other.updateBrand);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, updateBrand);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateBrandRequest.class,
                "accountID", accountID,
                "updateBrand", updateBrand);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private UpdateBrand updateBrand;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder updateBrand(UpdateBrand updateBrand) {
            Utils.checkNotNull(updateBrand, "updateBrand");
            this.updateBrand = updateBrand;
            return this;
        }

        public UpdateBrandRequest build() {

            return new UpdateBrandRequest(
                accountID, updateBrand);
        }

    }
}
