/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpdateApplePayMerchantDomains;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateApplePayMerchantDomainsRequest {
    /**
     * ID of the Moov account representing the merchant.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateApplePayMerchantDomains updateApplePayMerchantDomains;

    @JsonCreator
    public UpdateApplePayMerchantDomainsRequest(
            String accountID,
            UpdateApplePayMerchantDomains updateApplePayMerchantDomains) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(updateApplePayMerchantDomains, "updateApplePayMerchantDomains");
        this.accountID = accountID;
        this.updateApplePayMerchantDomains = updateApplePayMerchantDomains;
    }

    /**
     * ID of the Moov account representing the merchant.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public UpdateApplePayMerchantDomains updateApplePayMerchantDomains() {
        return updateApplePayMerchantDomains;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the Moov account representing the merchant.
     */
    public UpdateApplePayMerchantDomainsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateApplePayMerchantDomainsRequest withUpdateApplePayMerchantDomains(UpdateApplePayMerchantDomains updateApplePayMerchantDomains) {
        Utils.checkNotNull(updateApplePayMerchantDomains, "updateApplePayMerchantDomains");
        this.updateApplePayMerchantDomains = updateApplePayMerchantDomains;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateApplePayMerchantDomainsRequest other = (UpdateApplePayMerchantDomainsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.updateApplePayMerchantDomains, other.updateApplePayMerchantDomains);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, updateApplePayMerchantDomains);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateApplePayMerchantDomainsRequest.class,
                "accountID", accountID,
                "updateApplePayMerchantDomains", updateApplePayMerchantDomains);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private UpdateApplePayMerchantDomains updateApplePayMerchantDomains;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the Moov account representing the merchant.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder updateApplePayMerchantDomains(UpdateApplePayMerchantDomains updateApplePayMerchantDomains) {
            Utils.checkNotNull(updateApplePayMerchantDomains, "updateApplePayMerchantDomains");
            this.updateApplePayMerchantDomains = updateApplePayMerchantDomains;
            return this;
        }

        public UpdateApplePayMerchantDomainsRequest build() {

            return new UpdateApplePayMerchantDomainsRequest(
                accountID, updateApplePayMerchantDomains);
        }

    }
}
