/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.PatchAccount;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class UpdateAccountRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private PatchAccount patchAccount;

    @JsonCreator
    public UpdateAccountRequest(
            String accountID,
            PatchAccount patchAccount) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(patchAccount, "patchAccount");
        this.accountID = accountID;
        this.patchAccount = patchAccount;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public PatchAccount patchAccount() {
        return patchAccount;
    }

    public static Builder builder() {
        return new Builder();
    }


    public UpdateAccountRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public UpdateAccountRequest withPatchAccount(PatchAccount patchAccount) {
        Utils.checkNotNull(patchAccount, "patchAccount");
        this.patchAccount = patchAccount;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateAccountRequest other = (UpdateAccountRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.patchAccount, other.patchAccount);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, patchAccount);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UpdateAccountRequest.class,
                "accountID", accountID,
                "patchAccount", patchAccount);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private PatchAccount patchAccount;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder patchAccount(PatchAccount patchAccount) {
            Utils.checkNotNull(patchAccount, "patchAccount");
            this.patchAccount = patchAccount;
            return this;
        }

        public UpdateAccountRequest build() {

            return new UpdateAccountRequest(
                accountID, patchAccount);
        }

    }
}
