/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.UpsertUnderwriting;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class SaveUnderwritingRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpsertUnderwriting upsertUnderwriting;

    @JsonCreator
    public SaveUnderwritingRequest(
            String accountID,
            UpsertUnderwriting upsertUnderwriting) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(upsertUnderwriting, "upsertUnderwriting");
        this.accountID = accountID;
        this.upsertUnderwriting = upsertUnderwriting;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public UpsertUnderwriting upsertUnderwriting() {
        return upsertUnderwriting;
    }

    public static Builder builder() {
        return new Builder();
    }


    public SaveUnderwritingRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public SaveUnderwritingRequest withUpsertUnderwriting(UpsertUnderwriting upsertUnderwriting) {
        Utils.checkNotNull(upsertUnderwriting, "upsertUnderwriting");
        this.upsertUnderwriting = upsertUnderwriting;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SaveUnderwritingRequest other = (SaveUnderwritingRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.upsertUnderwriting, other.upsertUnderwriting);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, upsertUnderwriting);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SaveUnderwritingRequest.class,
                "accountID", accountID,
                "upsertUnderwriting", upsertUnderwriting);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private UpsertUnderwriting upsertUnderwriting;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder upsertUnderwriting(UpsertUnderwriting upsertUnderwriting) {
            Utils.checkNotNull(upsertUnderwriting, "upsertUnderwriting");
            this.upsertUnderwriting = upsertUnderwriting;
            return this;
        }

        public SaveUnderwritingRequest build() {

            return new SaveUnderwritingRequest(
                accountID, upsertUnderwriting);
        }

    }
}
