/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.SDKConfiguration;
import io.moov.sdk.models.components.RevokeTokenRequest;
import io.moov.sdk.models.components.TokenTypeHint;
import io.moov.sdk.operations.RevokeAccessTokenOperation;
import io.moov.sdk.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;

public class RevokeAccessTokenRequestBuilder {

    private String token;
    private Optional<? extends TokenTypeHint> tokenTypeHint = Optional.empty();
    private Optional<String> clientId = Optional.empty();
    private Optional<String> clientSecret = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public RevokeAccessTokenRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public RevokeAccessTokenRequestBuilder token(String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }
                
    public RevokeAccessTokenRequestBuilder tokenTypeHint(TokenTypeHint tokenTypeHint) {
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        this.tokenTypeHint = Optional.of(tokenTypeHint);
        return this;
    }

    public RevokeAccessTokenRequestBuilder tokenTypeHint(Optional<? extends TokenTypeHint> tokenTypeHint) {
        Utils.checkNotNull(tokenTypeHint, "tokenTypeHint");
        this.tokenTypeHint = tokenTypeHint;
        return this;
    }
                
    public RevokeAccessTokenRequestBuilder clientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = Optional.of(clientId);
        return this;
    }

    public RevokeAccessTokenRequestBuilder clientId(Optional<String> clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }
                
    public RevokeAccessTokenRequestBuilder clientSecret(String clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = Optional.of(clientSecret);
        return this;
    }

    public RevokeAccessTokenRequestBuilder clientSecret(Optional<String> clientSecret) {
        Utils.checkNotNull(clientSecret, "clientSecret");
        this.clientSecret = clientSecret;
        return this;
    }


    private RevokeTokenRequest buildRequest() {

        RevokeTokenRequest request = new RevokeTokenRequest(token,
            tokenTypeHint,
            clientId,
            clientSecret);

        return request;
    }

    public RevokeAccessTokenResponse call() throws Exception {
        
        RequestOperation<RevokeTokenRequest, RevokeAccessTokenResponse> operation
              = new RevokeAccessTokenOperation(sdkConfiguration);
        RevokeTokenRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
