/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class RetrieveFeesRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * Optional transfer ID to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=transferID")
    private Optional<String> transferID;

    /**
     * Optional dispute ID to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=disputeID")
    private Optional<String> disputeID;

    /**
     * Optional date-time to inclusively filter all fees created after this date-time.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=startDateTime")
    private Optional<String> startDateTime;

    /**
     * Optional date-time to exclusively filter all fees created before this date-time.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=endDateTime")
    private Optional<String> endDateTime;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=skip")
    private Optional<Long> skip;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;

    @JsonCreator
    public RetrieveFeesRequest(
            String accountID,
            Optional<String> transferID,
            Optional<String> disputeID,
            Optional<String> startDateTime,
            Optional<String> endDateTime,
            Optional<Long> skip,
            Optional<Long> count) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(disputeID, "disputeID");
        Utils.checkNotNull(startDateTime, "startDateTime");
        Utils.checkNotNull(endDateTime, "endDateTime");
        Utils.checkNotNull(skip, "skip");
        Utils.checkNotNull(count, "count");
        this.accountID = accountID;
        this.transferID = transferID;
        this.disputeID = disputeID;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.skip = skip;
        this.count = count;
    }
    
    public RetrieveFeesRequest(
            String accountID) {
        this(accountID, Optional.empty(), Optional.empty(),
            Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Optional transfer ID to filter the results by.
     */
    @JsonIgnore
    public Optional<String> transferID() {
        return transferID;
    }

    /**
     * Optional dispute ID to filter the results by.
     */
    @JsonIgnore
    public Optional<String> disputeID() {
        return disputeID;
    }

    /**
     * Optional date-time to inclusively filter all fees created after this date-time.
     */
    @JsonIgnore
    public Optional<String> startDateTime() {
        return startDateTime;
    }

    /**
     * Optional date-time to exclusively filter all fees created before this date-time.
     */
    @JsonIgnore
    public Optional<String> endDateTime() {
        return endDateTime;
    }

    @JsonIgnore
    public Optional<Long> skip() {
        return skip;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    public static Builder builder() {
        return new Builder();
    }


    public RetrieveFeesRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Optional transfer ID to filter the results by.
     */
    public RetrieveFeesRequest withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = Optional.ofNullable(transferID);
        return this;
    }


    /**
     * Optional transfer ID to filter the results by.
     */
    public RetrieveFeesRequest withTransferID(Optional<String> transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    /**
     * Optional dispute ID to filter the results by.
     */
    public RetrieveFeesRequest withDisputeID(String disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = Optional.ofNullable(disputeID);
        return this;
    }


    /**
     * Optional dispute ID to filter the results by.
     */
    public RetrieveFeesRequest withDisputeID(Optional<String> disputeID) {
        Utils.checkNotNull(disputeID, "disputeID");
        this.disputeID = disputeID;
        return this;
    }

    /**
     * Optional date-time to inclusively filter all fees created after this date-time.
     */
    public RetrieveFeesRequest withStartDateTime(String startDateTime) {
        Utils.checkNotNull(startDateTime, "startDateTime");
        this.startDateTime = Optional.ofNullable(startDateTime);
        return this;
    }


    /**
     * Optional date-time to inclusively filter all fees created after this date-time.
     */
    public RetrieveFeesRequest withStartDateTime(Optional<String> startDateTime) {
        Utils.checkNotNull(startDateTime, "startDateTime");
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Optional date-time to exclusively filter all fees created before this date-time.
     */
    public RetrieveFeesRequest withEndDateTime(String endDateTime) {
        Utils.checkNotNull(endDateTime, "endDateTime");
        this.endDateTime = Optional.ofNullable(endDateTime);
        return this;
    }


    /**
     * Optional date-time to exclusively filter all fees created before this date-time.
     */
    public RetrieveFeesRequest withEndDateTime(Optional<String> endDateTime) {
        Utils.checkNotNull(endDateTime, "endDateTime");
        this.endDateTime = endDateTime;
        return this;
    }

    public RetrieveFeesRequest withSkip(long skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = Optional.ofNullable(skip);
        return this;
    }


    public RetrieveFeesRequest withSkip(Optional<Long> skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = skip;
        return this;
    }

    public RetrieveFeesRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }


    public RetrieveFeesRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RetrieveFeesRequest other = (RetrieveFeesRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.disputeID, other.disputeID) &&
            Utils.enhancedDeepEquals(this.startDateTime, other.startDateTime) &&
            Utils.enhancedDeepEquals(this.endDateTime, other.endDateTime) &&
            Utils.enhancedDeepEquals(this.skip, other.skip) &&
            Utils.enhancedDeepEquals(this.count, other.count);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferID, disputeID,
            startDateTime, endDateTime, skip,
            count);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RetrieveFeesRequest.class,
                "accountID", accountID,
                "transferID", transferID,
                "disputeID", disputeID,
                "startDateTime", startDateTime,
                "endDateTime", endDateTime,
                "skip", skip,
                "count", count);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private Optional<String> transferID = Optional.empty();

        private Optional<String> disputeID = Optional.empty();

        private Optional<String> startDateTime = Optional.empty();

        private Optional<String> endDateTime = Optional.empty();

        private Optional<Long> skip = Optional.empty();

        private Optional<Long> count = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * Optional transfer ID to filter the results by.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = Optional.ofNullable(transferID);
            return this;
        }

        /**
         * Optional transfer ID to filter the results by.
         */
        public Builder transferID(Optional<String> transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        /**
         * Optional dispute ID to filter the results by.
         */
        public Builder disputeID(String disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = Optional.ofNullable(disputeID);
            return this;
        }

        /**
         * Optional dispute ID to filter the results by.
         */
        public Builder disputeID(Optional<String> disputeID) {
            Utils.checkNotNull(disputeID, "disputeID");
            this.disputeID = disputeID;
            return this;
        }


        /**
         * Optional date-time to inclusively filter all fees created after this date-time.
         */
        public Builder startDateTime(String startDateTime) {
            Utils.checkNotNull(startDateTime, "startDateTime");
            this.startDateTime = Optional.ofNullable(startDateTime);
            return this;
        }

        /**
         * Optional date-time to inclusively filter all fees created after this date-time.
         */
        public Builder startDateTime(Optional<String> startDateTime) {
            Utils.checkNotNull(startDateTime, "startDateTime");
            this.startDateTime = startDateTime;
            return this;
        }


        /**
         * Optional date-time to exclusively filter all fees created before this date-time.
         */
        public Builder endDateTime(String endDateTime) {
            Utils.checkNotNull(endDateTime, "endDateTime");
            this.endDateTime = Optional.ofNullable(endDateTime);
            return this;
        }

        /**
         * Optional date-time to exclusively filter all fees created before this date-time.
         */
        public Builder endDateTime(Optional<String> endDateTime) {
            Utils.checkNotNull(endDateTime, "endDateTime");
            this.endDateTime = endDateTime;
            return this;
        }


        public Builder skip(long skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = Optional.ofNullable(skip);
            return this;
        }

        public Builder skip(Optional<Long> skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = skip;
            return this;
        }


        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }

        public RetrieveFeesRequest build() {

            return new RetrieveFeesRequest(
                accountID, transferID, disputeID,
                startDateTime, endDateTime, skip,
                count);
        }

    }
}
