/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.RequestCard;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class RequestCardRequest {
    /**
     * The Moov business account for which the card is to be issued.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private RequestCard requestCard;

    @JsonCreator
    public RequestCardRequest(
            String accountID,
            RequestCard requestCard) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(requestCard, "requestCard");
        this.accountID = accountID;
        this.requestCard = requestCard;
    }

    /**
     * The Moov business account for which the card is to be issued.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public RequestCard requestCard() {
        return requestCard;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The Moov business account for which the card is to be issued.
     */
    public RequestCardRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public RequestCardRequest withRequestCard(RequestCard requestCard) {
        Utils.checkNotNull(requestCard, "requestCard");
        this.requestCard = requestCard;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RequestCardRequest other = (RequestCardRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.requestCard, other.requestCard);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, requestCard);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RequestCardRequest.class,
                "accountID", accountID,
                "requestCard", requestCard);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private RequestCard requestCard;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The Moov business account for which the card is to be issued.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder requestCard(RequestCard requestCard) {
            Utils.checkNotNull(requestCard, "requestCard");
            this.requestCard = requestCard;
            return this;
        }

        public RequestCardRequest build() {

            return new RequestCardRequest(
                accountID, requestCard);
        }

    }
}
