/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.RegisterApplePayMerchantDomains;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class RegisterApplePayMerchantDomainsRequest {
    /**
     * ID of the Moov account representing the merchant.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private RegisterApplePayMerchantDomains registerApplePayMerchantDomains;

    @JsonCreator
    public RegisterApplePayMerchantDomainsRequest(
            String accountID,
            RegisterApplePayMerchantDomains registerApplePayMerchantDomains) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(registerApplePayMerchantDomains, "registerApplePayMerchantDomains");
        this.accountID = accountID;
        this.registerApplePayMerchantDomains = registerApplePayMerchantDomains;
    }

    /**
     * ID of the Moov account representing the merchant.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public RegisterApplePayMerchantDomains registerApplePayMerchantDomains() {
        return registerApplePayMerchantDomains;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the Moov account representing the merchant.
     */
    public RegisterApplePayMerchantDomainsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public RegisterApplePayMerchantDomainsRequest withRegisterApplePayMerchantDomains(RegisterApplePayMerchantDomains registerApplePayMerchantDomains) {
        Utils.checkNotNull(registerApplePayMerchantDomains, "registerApplePayMerchantDomains");
        this.registerApplePayMerchantDomains = registerApplePayMerchantDomains;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegisterApplePayMerchantDomainsRequest other = (RegisterApplePayMerchantDomainsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.registerApplePayMerchantDomains, other.registerApplePayMerchantDomains);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, registerApplePayMerchantDomains);
    }
    
    @Override
    public String toString() {
        return Utils.toString(RegisterApplePayMerchantDomainsRequest.class,
                "accountID", accountID,
                "registerApplePayMerchantDomains", registerApplePayMerchantDomains);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private RegisterApplePayMerchantDomains registerApplePayMerchantDomains;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the Moov account representing the merchant.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder registerApplePayMerchantDomains(RegisterApplePayMerchantDomains registerApplePayMerchantDomains) {
            Utils.checkNotNull(registerApplePayMerchantDomains, "registerApplePayMerchantDomains");
            this.registerApplePayMerchantDomains = registerApplePayMerchantDomains;
            return this;
        }

        public RegisterApplePayMerchantDomainsRequest build() {

            return new RegisterApplePayMerchantDomainsRequest(
                accountID, registerApplePayMerchantDomains);
        }

    }
}
