/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.moov.sdk.models.components.ItemListNextPage;
import io.moov.sdk.models.components.Ticket;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Optional;

/**
 * ListTicketsResponseBody
 * 
 * <p>A paginated list of items. The `nextPage` field is omitted if there are no more pages available.
 */
public class ListTicketsResponseBody {

    @JsonProperty("items")
    private List<Ticket> items;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("nextPage")
    private Optional<? extends ItemListNextPage> nextPage;

    @JsonCreator
    public ListTicketsResponseBody(
            @JsonProperty("items") List<Ticket> items,
            @JsonProperty("nextPage") Optional<? extends ItemListNextPage> nextPage) {
        Utils.checkNotNull(items, "items");
        Utils.checkNotNull(nextPage, "nextPage");
        this.items = items;
        this.nextPage = nextPage;
    }
    
    public ListTicketsResponseBody(
            List<Ticket> items) {
        this(items, Optional.empty());
    }

    @JsonIgnore
    public List<Ticket> items() {
        return items;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ItemListNextPage> nextPage() {
        return (Optional<ItemListNextPage>) nextPage;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListTicketsResponseBody withItems(List<Ticket> items) {
        Utils.checkNotNull(items, "items");
        this.items = items;
        return this;
    }

    public ListTicketsResponseBody withNextPage(ItemListNextPage nextPage) {
        Utils.checkNotNull(nextPage, "nextPage");
        this.nextPage = Optional.ofNullable(nextPage);
        return this;
    }


    public ListTicketsResponseBody withNextPage(Optional<? extends ItemListNextPage> nextPage) {
        Utils.checkNotNull(nextPage, "nextPage");
        this.nextPage = nextPage;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListTicketsResponseBody other = (ListTicketsResponseBody) o;
        return 
            Utils.enhancedDeepEquals(this.items, other.items) &&
            Utils.enhancedDeepEquals(this.nextPage, other.nextPage);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            items, nextPage);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListTicketsResponseBody.class,
                "items", items,
                "nextPage", nextPage);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private List<Ticket> items;

        private Optional<? extends ItemListNextPage> nextPage = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder items(List<Ticket> items) {
            Utils.checkNotNull(items, "items");
            this.items = items;
            return this;
        }


        public Builder nextPage(ItemListNextPage nextPage) {
            Utils.checkNotNull(nextPage, "nextPage");
            this.nextPage = Optional.ofNullable(nextPage);
            return this;
        }

        public Builder nextPage(Optional<? extends ItemListNextPage> nextPage) {
            Utils.checkNotNull(nextPage, "nextPage");
            this.nextPage = nextPage;
            return this;
        }

        public ListTicketsResponseBody build() {

            return new ListTicketsResponseBody(
                items, nextPage);
        }

    }
}
