/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.TicketStatus;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class ListTicketsRequest {

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=cursor")
    private Optional<String> cursor;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=status")
    private Optional<? extends TicketStatus> status;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    @JsonCreator
    public ListTicketsRequest(
            Optional<String> cursor,
            Optional<Long> count,
            Optional<? extends TicketStatus> status,
            String accountID) {
        Utils.checkNotNull(cursor, "cursor");
        Utils.checkNotNull(count, "count");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(accountID, "accountID");
        this.cursor = cursor;
        this.count = count;
        this.status = status;
        this.accountID = accountID;
    }
    
    public ListTicketsRequest(
            String accountID) {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            accountID);
    }

    @JsonIgnore
    public Optional<String> cursor() {
        return cursor;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TicketStatus> status() {
        return (Optional<TicketStatus>) status;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListTicketsRequest withCursor(String cursor) {
        Utils.checkNotNull(cursor, "cursor");
        this.cursor = Optional.ofNullable(cursor);
        return this;
    }


    public ListTicketsRequest withCursor(Optional<String> cursor) {
        Utils.checkNotNull(cursor, "cursor");
        this.cursor = cursor;
        return this;
    }

    public ListTicketsRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }


    public ListTicketsRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    public ListTicketsRequest withStatus(TicketStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }


    public ListTicketsRequest withStatus(Optional<? extends TicketStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ListTicketsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListTicketsRequest other = (ListTicketsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.cursor, other.cursor) &&
            Utils.enhancedDeepEquals(this.count, other.count) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            cursor, count, status,
            accountID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListTicketsRequest.class,
                "cursor", cursor,
                "count", count,
                "status", status,
                "accountID", accountID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> cursor = Optional.empty();

        private Optional<Long> count = Optional.empty();

        private Optional<? extends TicketStatus> status = Optional.empty();

        private String accountID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder cursor(String cursor) {
            Utils.checkNotNull(cursor, "cursor");
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Optional<String> cursor) {
            Utils.checkNotNull(cursor, "cursor");
            this.cursor = cursor;
            return this;
        }


        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }


        public Builder status(TicketStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        public Builder status(Optional<? extends TicketStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public ListTicketsRequest build() {

            return new ListTicketsRequest(
                cursor, count, status,
                accountID);
        }

    }
}
