/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class ListSchedulesRequest {

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=skip")
    private Optional<Long> skip;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=hydrate")
    private Optional<? extends Hydrate> hydrate;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    @JsonCreator
    public ListSchedulesRequest(
            Optional<Long> skip,
            Optional<Long> count,
            Optional<? extends Hydrate> hydrate,
            String accountID) {
        Utils.checkNotNull(skip, "skip");
        Utils.checkNotNull(count, "count");
        Utils.checkNotNull(hydrate, "hydrate");
        Utils.checkNotNull(accountID, "accountID");
        this.skip = skip;
        this.count = count;
        this.hydrate = hydrate;
        this.accountID = accountID;
    }
    
    public ListSchedulesRequest(
            String accountID) {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            accountID);
    }

    @JsonIgnore
    public Optional<Long> skip() {
        return skip;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Hydrate> hydrate() {
        return (Optional<Hydrate>) hydrate;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListSchedulesRequest withSkip(long skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = Optional.ofNullable(skip);
        return this;
    }


    public ListSchedulesRequest withSkip(Optional<Long> skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = skip;
        return this;
    }

    public ListSchedulesRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }


    public ListSchedulesRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    public ListSchedulesRequest withHydrate(Hydrate hydrate) {
        Utils.checkNotNull(hydrate, "hydrate");
        this.hydrate = Optional.ofNullable(hydrate);
        return this;
    }


    public ListSchedulesRequest withHydrate(Optional<? extends Hydrate> hydrate) {
        Utils.checkNotNull(hydrate, "hydrate");
        this.hydrate = hydrate;
        return this;
    }

    public ListSchedulesRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListSchedulesRequest other = (ListSchedulesRequest) o;
        return 
            Utils.enhancedDeepEquals(this.skip, other.skip) &&
            Utils.enhancedDeepEquals(this.count, other.count) &&
            Utils.enhancedDeepEquals(this.hydrate, other.hydrate) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            skip, count, hydrate,
            accountID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListSchedulesRequest.class,
                "skip", skip,
                "count", count,
                "hydrate", hydrate,
                "accountID", accountID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<Long> skip = Optional.empty();

        private Optional<Long> count = Optional.empty();

        private Optional<? extends Hydrate> hydrate = Optional.empty();

        private String accountID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder skip(long skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = Optional.ofNullable(skip);
            return this;
        }

        public Builder skip(Optional<Long> skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = skip;
            return this;
        }


        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }


        public Builder hydrate(Hydrate hydrate) {
            Utils.checkNotNull(hydrate, "hydrate");
            this.hydrate = Optional.ofNullable(hydrate);
            return this;
        }

        public Builder hydrate(Optional<? extends Hydrate> hydrate) {
            Utils.checkNotNull(hydrate, "hydrate");
            this.hydrate = hydrate;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public ListSchedulesRequest build() {

            return new ListSchedulesRequest(
                skip, count, hydrate,
                accountID);
        }

    }
}
