/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class ListRefundsRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * Identifier for the transfer.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=transferID")
    private String transferID;

    @JsonCreator
    public ListRefundsRequest(
            String accountID,
            String transferID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        this.accountID = accountID;
        this.transferID = transferID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Identifier for the transfer.
     */
    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListRefundsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Identifier for the transfer.
     */
    public ListRefundsRequest withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListRefundsRequest other = (ListRefundsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, transferID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListRefundsRequest.class,
                "accountID", accountID,
                "transferID", transferID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String transferID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * Identifier for the transfer.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }

        public ListRefundsRequest build() {

            return new ListRefundsRequest(
                accountID, transferID);
        }

    }
}
