/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.SDKConfiguration;
import io.moov.sdk.models.components.PaymentMethodType;
import io.moov.sdk.operations.ListPaymentMethodsOperation;
import io.moov.sdk.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;

public class ListPaymentMethodsRequestBuilder {

    private String accountID;
    private Optional<String> sourceID = Optional.empty();
    private Optional<? extends PaymentMethodType> paymentMethodType = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public ListPaymentMethodsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public ListPaymentMethodsRequestBuilder accountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }
                
    public ListPaymentMethodsRequestBuilder sourceID(String sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = Optional.of(sourceID);
        return this;
    }

    public ListPaymentMethodsRequestBuilder sourceID(Optional<String> sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = sourceID;
        return this;
    }
                
    public ListPaymentMethodsRequestBuilder paymentMethodType(PaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = Optional.of(paymentMethodType);
        return this;
    }

    public ListPaymentMethodsRequestBuilder paymentMethodType(Optional<? extends PaymentMethodType> paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }


    private ListPaymentMethodsRequest buildRequest() {

        ListPaymentMethodsRequest request = new ListPaymentMethodsRequest(accountID,
            sourceID,
            paymentMethodType);

        return request;
    }

    public ListPaymentMethodsResponse call() throws Exception {
        
        RequestOperation<ListPaymentMethodsRequest, ListPaymentMethodsResponse> operation
              = new ListPaymentMethodsOperation(sdkConfiguration);
        ListPaymentMethodsRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
