/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.PaymentMethodType;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class ListPaymentMethodsRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=sourceID")
    private Optional<String> sourceID;

    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=paymentMethodType")
    private Optional<? extends PaymentMethodType> paymentMethodType;

    @JsonCreator
    public ListPaymentMethodsRequest(
            String accountID,
            Optional<String> sourceID,
            Optional<? extends PaymentMethodType> paymentMethodType) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(sourceID, "sourceID");
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.accountID = accountID;
        this.sourceID = sourceID;
        this.paymentMethodType = paymentMethodType;
    }
    
    public ListPaymentMethodsRequest(
            String accountID) {
        this(accountID, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    @JsonIgnore
    public Optional<String> sourceID() {
        return sourceID;
    }

    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PaymentMethodType> paymentMethodType() {
        return (Optional<PaymentMethodType>) paymentMethodType;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListPaymentMethodsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    public ListPaymentMethodsRequest withSourceID(String sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = Optional.ofNullable(sourceID);
        return this;
    }


    /**
     * Optional parameter to filter the account's payment methods by source ID. 
     * 
     * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
     * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
     */
    public ListPaymentMethodsRequest withSourceID(Optional<String> sourceID) {
        Utils.checkNotNull(sourceID, "sourceID");
        this.sourceID = sourceID;
        return this;
    }

    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    public ListPaymentMethodsRequest withPaymentMethodType(PaymentMethodType paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = Optional.ofNullable(paymentMethodType);
        return this;
    }


    /**
     * Optional parameter to filter the account's payment methods by payment method type.
     */
    public ListPaymentMethodsRequest withPaymentMethodType(Optional<? extends PaymentMethodType> paymentMethodType) {
        Utils.checkNotNull(paymentMethodType, "paymentMethodType");
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListPaymentMethodsRequest other = (ListPaymentMethodsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.sourceID, other.sourceID) &&
            Utils.enhancedDeepEquals(this.paymentMethodType, other.paymentMethodType);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, sourceID, paymentMethodType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListPaymentMethodsRequest.class,
                "accountID", accountID,
                "sourceID", sourceID,
                "paymentMethodType", paymentMethodType);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private Optional<String> sourceID = Optional.empty();

        private Optional<? extends PaymentMethodType> paymentMethodType = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * Optional parameter to filter the account's payment methods by source ID. 
         * 
         * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
         * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
         */
        public Builder sourceID(String sourceID) {
            Utils.checkNotNull(sourceID, "sourceID");
            this.sourceID = Optional.ofNullable(sourceID);
            return this;
        }

        /**
         * Optional parameter to filter the account's payment methods by source ID. 
         * 
         * <p>A source ID can be a [walletID](https://docs.moov.io/api/sources/wallets/list/), [cardID](https://docs.moov.io/api/sources/cards/list/), 
         * or [bankAccountID](https://docs.moov.io/api/sources/bank-accounts/list/).
         */
        public Builder sourceID(Optional<String> sourceID) {
            Utils.checkNotNull(sourceID, "sourceID");
            this.sourceID = sourceID;
            return this;
        }


        /**
         * Optional parameter to filter the account's payment methods by payment method type.
         */
        public Builder paymentMethodType(PaymentMethodType paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = Optional.ofNullable(paymentMethodType);
            return this;
        }

        /**
         * Optional parameter to filter the account's payment methods by payment method type.
         */
        public Builder paymentMethodType(Optional<? extends PaymentMethodType> paymentMethodType) {
            Utils.checkNotNull(paymentMethodType, "paymentMethodType");
            this.paymentMethodType = paymentMethodType;
            return this;
        }

        public ListPaymentMethodsRequest build() {

            return new ListPaymentMethodsRequest(
                accountID, sourceID, paymentMethodType);
        }

    }
}
