/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Optional;


public class ListPartnerPricingRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * A comma-separated list of plan IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=planIDs")
    private Optional<? extends List<String>> planIDs;

    @JsonCreator
    public ListPartnerPricingRequest(
            String accountID,
            Optional<? extends List<String>> planIDs) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(planIDs, "planIDs");
        this.accountID = accountID;
        this.planIDs = planIDs;
    }
    
    public ListPartnerPricingRequest(
            String accountID) {
        this(accountID, Optional.empty());
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * A comma-separated list of plan IDs to filter the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> planIDs() {
        return (Optional<List<String>>) planIDs;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListPartnerPricingRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * A comma-separated list of plan IDs to filter the results by.
     */
    public ListPartnerPricingRequest withPlanIDs(List<String> planIDs) {
        Utils.checkNotNull(planIDs, "planIDs");
        this.planIDs = Optional.ofNullable(planIDs);
        return this;
    }


    /**
     * A comma-separated list of plan IDs to filter the results by.
     */
    public ListPartnerPricingRequest withPlanIDs(Optional<? extends List<String>> planIDs) {
        Utils.checkNotNull(planIDs, "planIDs");
        this.planIDs = planIDs;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListPartnerPricingRequest other = (ListPartnerPricingRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.planIDs, other.planIDs);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, planIDs);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListPartnerPricingRequest.class,
                "accountID", accountID,
                "planIDs", planIDs);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private Optional<? extends List<String>> planIDs = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * A comma-separated list of plan IDs to filter the results by.
         */
        public Builder planIDs(List<String> planIDs) {
            Utils.checkNotNull(planIDs, "planIDs");
            this.planIDs = Optional.ofNullable(planIDs);
            return this;
        }

        /**
         * A comma-separated list of plan IDs to filter the results by.
         */
        public Builder planIDs(Optional<? extends List<String>> planIDs) {
            Utils.checkNotNull(planIDs, "planIDs");
            this.planIDs = planIDs;
            return this;
        }

        public ListPartnerPricingRequest build() {

            return new ListPartnerPricingRequest(
                accountID, planIDs);
        }

    }
}
