/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.IssuedCardState;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Optional;


public class ListIssuedCardsRequest {
    /**
     * The Moov business account for which the cards have been issued.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=skip")
    private Optional<Long> skip;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;

    /**
     * Optional, comma-separated states to filter the Moov list issued cards response. For example `active,pending-verification`
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=states")
    private Optional<? extends List<IssuedCardState>> states;

    @JsonCreator
    public ListIssuedCardsRequest(
            String accountID,
            Optional<Long> skip,
            Optional<Long> count,
            Optional<? extends List<IssuedCardState>> states) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(skip, "skip");
        Utils.checkNotNull(count, "count");
        Utils.checkNotNull(states, "states");
        this.accountID = accountID;
        this.skip = skip;
        this.count = count;
        this.states = states;
    }
    
    public ListIssuedCardsRequest(
            String accountID) {
        this(accountID, Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * The Moov business account for which the cards have been issued.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public Optional<Long> skip() {
        return skip;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    /**
     * Optional, comma-separated states to filter the Moov list issued cards response. For example `active,pending-verification`
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<IssuedCardState>> states() {
        return (Optional<List<IssuedCardState>>) states;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The Moov business account for which the cards have been issued.
     */
    public ListIssuedCardsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public ListIssuedCardsRequest withSkip(long skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = Optional.ofNullable(skip);
        return this;
    }


    public ListIssuedCardsRequest withSkip(Optional<Long> skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = skip;
        return this;
    }

    public ListIssuedCardsRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }


    public ListIssuedCardsRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    /**
     * Optional, comma-separated states to filter the Moov list issued cards response. For example `active,pending-verification`
     */
    public ListIssuedCardsRequest withStates(List<IssuedCardState> states) {
        Utils.checkNotNull(states, "states");
        this.states = Optional.ofNullable(states);
        return this;
    }


    /**
     * Optional, comma-separated states to filter the Moov list issued cards response. For example `active,pending-verification`
     */
    public ListIssuedCardsRequest withStates(Optional<? extends List<IssuedCardState>> states) {
        Utils.checkNotNull(states, "states");
        this.states = states;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListIssuedCardsRequest other = (ListIssuedCardsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.skip, other.skip) &&
            Utils.enhancedDeepEquals(this.count, other.count) &&
            Utils.enhancedDeepEquals(this.states, other.states);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, skip, count,
            states);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListIssuedCardsRequest.class,
                "accountID", accountID,
                "skip", skip,
                "count", count,
                "states", states);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private Optional<Long> skip = Optional.empty();

        private Optional<Long> count = Optional.empty();

        private Optional<? extends List<IssuedCardState>> states = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The Moov business account for which the cards have been issued.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder skip(long skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = Optional.ofNullable(skip);
            return this;
        }

        public Builder skip(Optional<Long> skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = skip;
            return this;
        }


        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }


        /**
         * Optional, comma-separated states to filter the Moov list issued cards response. For example `active,pending-verification`
         */
        public Builder states(List<IssuedCardState> states) {
            Utils.checkNotNull(states, "states");
            this.states = Optional.ofNullable(states);
            return this;
        }

        /**
         * Optional, comma-separated states to filter the Moov list issued cards response. For example `active,pending-verification`
         */
        public Builder states(Optional<? extends List<IssuedCardState>> states) {
            Utils.checkNotNull(states, "states");
            this.states = states;
            return this;
        }

        public ListIssuedCardsRequest build() {

            return new ListIssuedCardsRequest(
                accountID, skip, count,
                states);
        }

    }
}
