/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class ListInstitutionsRequest {
    /**
     * Name of the financial institution. Either `name` or `routingNumber` is required.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=name")
    private Optional<String> name;

    /**
     * Routing number for a financial institution. Either `routingNumber` or `name` is required.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=routingNumber")
    private Optional<String> routingNumber;

    /**
     * The state where a financial institution is based.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=state")
    private Optional<String> state;

    /**
     * Maximum results returned by a search.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=limit")
    private Optional<Long> limit;

    @JsonCreator
    public ListInstitutionsRequest(
            Optional<String> name,
            Optional<String> routingNumber,
            Optional<String> state,
            Optional<Long> limit) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(routingNumber, "routingNumber");
        Utils.checkNotNull(state, "state");
        Utils.checkNotNull(limit, "limit");
        this.name = name;
        this.routingNumber = routingNumber;
        this.state = state;
        this.limit = limit;
    }
    
    public ListInstitutionsRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            Optional.empty());
    }

    /**
     * Name of the financial institution. Either `name` or `routingNumber` is required.
     */
    @JsonIgnore
    public Optional<String> name() {
        return name;
    }

    /**
     * Routing number for a financial institution. Either `routingNumber` or `name` is required.
     */
    @JsonIgnore
    public Optional<String> routingNumber() {
        return routingNumber;
    }

    /**
     * The state where a financial institution is based.
     */
    @JsonIgnore
    public Optional<String> state() {
        return state;
    }

    /**
     * Maximum results returned by a search.
     */
    @JsonIgnore
    public Optional<Long> limit() {
        return limit;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Name of the financial institution. Either `name` or `routingNumber` is required.
     */
    public ListInstitutionsRequest withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }


    /**
     * Name of the financial institution. Either `name` or `routingNumber` is required.
     */
    public ListInstitutionsRequest withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Routing number for a financial institution. Either `routingNumber` or `name` is required.
     */
    public ListInstitutionsRequest withRoutingNumber(String routingNumber) {
        Utils.checkNotNull(routingNumber, "routingNumber");
        this.routingNumber = Optional.ofNullable(routingNumber);
        return this;
    }


    /**
     * Routing number for a financial institution. Either `routingNumber` or `name` is required.
     */
    public ListInstitutionsRequest withRoutingNumber(Optional<String> routingNumber) {
        Utils.checkNotNull(routingNumber, "routingNumber");
        this.routingNumber = routingNumber;
        return this;
    }

    /**
     * The state where a financial institution is based.
     */
    public ListInstitutionsRequest withState(String state) {
        Utils.checkNotNull(state, "state");
        this.state = Optional.ofNullable(state);
        return this;
    }


    /**
     * The state where a financial institution is based.
     */
    public ListInstitutionsRequest withState(Optional<String> state) {
        Utils.checkNotNull(state, "state");
        this.state = state;
        return this;
    }

    /**
     * Maximum results returned by a search.
     */
    public ListInstitutionsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }


    /**
     * Maximum results returned by a search.
     */
    public ListInstitutionsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListInstitutionsRequest other = (ListInstitutionsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.routingNumber, other.routingNumber) &&
            Utils.enhancedDeepEquals(this.state, other.state) &&
            Utils.enhancedDeepEquals(this.limit, other.limit);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            name, routingNumber, state,
            limit);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListInstitutionsRequest.class,
                "name", name,
                "routingNumber", routingNumber,
                "state", state,
                "limit", limit);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> name = Optional.empty();

        private Optional<String> routingNumber = Optional.empty();

        private Optional<String> state = Optional.empty();

        private Optional<Long> limit = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Name of the financial institution. Either `name` or `routingNumber` is required.
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * Name of the financial institution. Either `name` or `routingNumber` is required.
         */
        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * Routing number for a financial institution. Either `routingNumber` or `name` is required.
         */
        public Builder routingNumber(String routingNumber) {
            Utils.checkNotNull(routingNumber, "routingNumber");
            this.routingNumber = Optional.ofNullable(routingNumber);
            return this;
        }

        /**
         * Routing number for a financial institution. Either `routingNumber` or `name` is required.
         */
        public Builder routingNumber(Optional<String> routingNumber) {
            Utils.checkNotNull(routingNumber, "routingNumber");
            this.routingNumber = routingNumber;
            return this;
        }


        /**
         * The state where a financial institution is based.
         */
        public Builder state(String state) {
            Utils.checkNotNull(state, "state");
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * The state where a financial institution is based.
         */
        public Builder state(Optional<String> state) {
            Utils.checkNotNull(state, "state");
            this.state = state;
            return this;
        }


        /**
         * Maximum results returned by a search.
         */
        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * Maximum results returned by a search.
         */
        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public ListInstitutionsRequest build() {

            return new ListInstitutionsRequest(
                name, routingNumber, state,
                limit);
        }

    }
}
