/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.FeePlanAgreementStatus;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Optional;


public class ListFeePlanAgreementsRequest {

    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=skip")
    private Optional<Long> skip;


    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=count")
    private Optional<Long> count;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=agreementID")
    private Optional<? extends List<String>> agreementID;

    /**
     * A comma-separated list of statuses to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=status")
    private Optional<? extends List<FeePlanAgreementStatus>> status;

    @JsonCreator
    public ListFeePlanAgreementsRequest(
            Optional<Long> skip,
            Optional<Long> count,
            String accountID,
            Optional<? extends List<String>> agreementID,
            Optional<? extends List<FeePlanAgreementStatus>> status) {
        Utils.checkNotNull(skip, "skip");
        Utils.checkNotNull(count, "count");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(agreementID, "agreementID");
        Utils.checkNotNull(status, "status");
        this.skip = skip;
        this.count = count;
        this.accountID = accountID;
        this.agreementID = agreementID;
        this.status = status;
    }
    
    public ListFeePlanAgreementsRequest(
            String accountID) {
        this(Optional.empty(), Optional.empty(), accountID,
            Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Long> skip() {
        return skip;
    }

    @JsonIgnore
    public Optional<Long> count() {
        return count;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<String>> agreementID() {
        return (Optional<List<String>>) agreementID;
    }

    /**
     * A comma-separated list of statuses to filter the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<List<FeePlanAgreementStatus>> status() {
        return (Optional<List<FeePlanAgreementStatus>>) status;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListFeePlanAgreementsRequest withSkip(long skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = Optional.ofNullable(skip);
        return this;
    }


    public ListFeePlanAgreementsRequest withSkip(Optional<Long> skip) {
        Utils.checkNotNull(skip, "skip");
        this.skip = skip;
        return this;
    }

    public ListFeePlanAgreementsRequest withCount(long count) {
        Utils.checkNotNull(count, "count");
        this.count = Optional.ofNullable(count);
        return this;
    }


    public ListFeePlanAgreementsRequest withCount(Optional<Long> count) {
        Utils.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    public ListFeePlanAgreementsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    public ListFeePlanAgreementsRequest withAgreementID(List<String> agreementID) {
        Utils.checkNotNull(agreementID, "agreementID");
        this.agreementID = Optional.ofNullable(agreementID);
        return this;
    }


    /**
     * A comma-separated list of agreement IDs to filter the results by.
     */
    public ListFeePlanAgreementsRequest withAgreementID(Optional<? extends List<String>> agreementID) {
        Utils.checkNotNull(agreementID, "agreementID");
        this.agreementID = agreementID;
        return this;
    }

    /**
     * A comma-separated list of statuses to filter the results by.
     */
    public ListFeePlanAgreementsRequest withStatus(List<FeePlanAgreementStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = Optional.ofNullable(status);
        return this;
    }


    /**
     * A comma-separated list of statuses to filter the results by.
     */
    public ListFeePlanAgreementsRequest withStatus(Optional<? extends List<FeePlanAgreementStatus>> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListFeePlanAgreementsRequest other = (ListFeePlanAgreementsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.skip, other.skip) &&
            Utils.enhancedDeepEquals(this.count, other.count) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.agreementID, other.agreementID) &&
            Utils.enhancedDeepEquals(this.status, other.status);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            skip, count, accountID,
            agreementID, status);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListFeePlanAgreementsRequest.class,
                "skip", skip,
                "count", count,
                "accountID", accountID,
                "agreementID", agreementID,
                "status", status);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<Long> skip = Optional.empty();

        private Optional<Long> count = Optional.empty();

        private String accountID;

        private Optional<? extends List<String>> agreementID = Optional.empty();

        private Optional<? extends List<FeePlanAgreementStatus>> status = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder skip(long skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = Optional.ofNullable(skip);
            return this;
        }

        public Builder skip(Optional<Long> skip) {
            Utils.checkNotNull(skip, "skip");
            this.skip = skip;
            return this;
        }


        public Builder count(long count) {
            Utils.checkNotNull(count, "count");
            this.count = Optional.ofNullable(count);
            return this;
        }

        public Builder count(Optional<Long> count) {
            Utils.checkNotNull(count, "count");
            this.count = count;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * A comma-separated list of agreement IDs to filter the results by.
         */
        public Builder agreementID(List<String> agreementID) {
            Utils.checkNotNull(agreementID, "agreementID");
            this.agreementID = Optional.ofNullable(agreementID);
            return this;
        }

        /**
         * A comma-separated list of agreement IDs to filter the results by.
         */
        public Builder agreementID(Optional<? extends List<String>> agreementID) {
            Utils.checkNotNull(agreementID, "agreementID");
            this.agreementID = agreementID;
            return this;
        }


        /**
         * A comma-separated list of statuses to filter the results by.
         */
        public Builder status(List<FeePlanAgreementStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * A comma-separated list of statuses to filter the results by.
         */
        public Builder status(Optional<? extends List<FeePlanAgreementStatus>> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public ListFeePlanAgreementsRequest build() {

            return new ListFeePlanAgreementsRequest(
                skip, count, accountID,
                agreementID, status);
        }

    }
}
