/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class ListAdjustmentsRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * A wallet ID to filter adjustments by.
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=false,name=walletID")
    private Optional<String> walletID;

    @JsonCreator
    public ListAdjustmentsRequest(
            String accountID,
            Optional<String> walletID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(walletID, "walletID");
        this.accountID = accountID;
        this.walletID = walletID;
    }
    
    public ListAdjustmentsRequest(
            String accountID) {
        this(accountID, Optional.empty());
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * A wallet ID to filter adjustments by.
     */
    @JsonIgnore
    public Optional<String> walletID() {
        return walletID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public ListAdjustmentsRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * A wallet ID to filter adjustments by.
     */
    public ListAdjustmentsRequest withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = Optional.ofNullable(walletID);
        return this;
    }


    /**
     * A wallet ID to filter adjustments by.
     */
    public ListAdjustmentsRequest withWalletID(Optional<String> walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListAdjustmentsRequest other = (ListAdjustmentsRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.walletID, other.walletID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, walletID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ListAdjustmentsRequest.class,
                "accountID", accountID,
                "walletID", walletID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private Optional<String> walletID = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * A wallet ID to filter adjustments by.
         */
        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = Optional.ofNullable(walletID);
            return this;
        }

        /**
         * A wallet ID to filter adjustments by.
         */
        public Builder walletID(Optional<String> walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }

        public ListAdjustmentsRequest build() {

            return new ListAdjustmentsRequest(
                accountID, walletID);
        }

    }
}
