/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import static io.moov.sdk.operations.Operations.RequestOperation;

import io.moov.sdk.SDKConfiguration;
import io.moov.sdk.models.components.LinkCard;
import io.moov.sdk.models.components.LinkCardWaitFor;
import io.moov.sdk.operations.LinkCardOperation;
import io.moov.sdk.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;

public class LinkCardRequestBuilder {

    private Optional<? extends LinkCardWaitFor> xWaitFor = Optional.empty();
    private String accountID;
    private LinkCard linkCard;
    private final SDKConfiguration sdkConfiguration;

    public LinkCardRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }
                
    public LinkCardRequestBuilder xWaitFor(LinkCardWaitFor xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = Optional.of(xWaitFor);
        return this;
    }

    public LinkCardRequestBuilder xWaitFor(Optional<? extends LinkCardWaitFor> xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = xWaitFor;
        return this;
    }

    public LinkCardRequestBuilder accountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public LinkCardRequestBuilder linkCard(LinkCard linkCard) {
        Utils.checkNotNull(linkCard, "linkCard");
        this.linkCard = linkCard;
        return this;
    }


    private LinkCardRequest buildRequest() {

        LinkCardRequest request = new LinkCardRequest(xWaitFor,
            accountID,
            linkCard);

        return request;
    }

    public LinkCardResponse call() throws Exception {
        
        RequestOperation<LinkCardRequest, LinkCardResponse> operation
              = new LinkCardOperation(sdkConfiguration);
        LinkCardRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
