/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.LinkCard;
import io.moov.sdk.models.components.LinkCardWaitFor;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class LinkCardRequest {
    /**
     * Optional header to wait for certain events, such as the creation of a payment method, to occur before returning a response.
     * 
     * <p>When this header is set to `payment-method`, the response will include any payment methods that were created for the newly 
     * linked card in the `paymentMethods` field. Otherwise, the `paymentMethods` field will be omitted from the response.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-wait-for")
    private Optional<? extends LinkCardWaitFor> xWaitFor;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private LinkCard linkCard;

    @JsonCreator
    public LinkCardRequest(
            Optional<? extends LinkCardWaitFor> xWaitFor,
            String accountID,
            LinkCard linkCard) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(linkCard, "linkCard");
        this.xWaitFor = xWaitFor;
        this.accountID = accountID;
        this.linkCard = linkCard;
    }
    
    public LinkCardRequest(
            String accountID,
            LinkCard linkCard) {
        this(Optional.empty(), accountID, linkCard);
    }

    /**
     * Optional header to wait for certain events, such as the creation of a payment method, to occur before returning a response.
     * 
     * <p>When this header is set to `payment-method`, the response will include any payment methods that were created for the newly 
     * linked card in the `paymentMethods` field. Otherwise, the `paymentMethods` field will be omitted from the response.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<LinkCardWaitFor> xWaitFor() {
        return (Optional<LinkCardWaitFor>) xWaitFor;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public LinkCard linkCard() {
        return linkCard;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Optional header to wait for certain events, such as the creation of a payment method, to occur before returning a response.
     * 
     * <p>When this header is set to `payment-method`, the response will include any payment methods that were created for the newly 
     * linked card in the `paymentMethods` field. Otherwise, the `paymentMethods` field will be omitted from the response.
     */
    public LinkCardRequest withXWaitFor(LinkCardWaitFor xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = Optional.ofNullable(xWaitFor);
        return this;
    }


    /**
     * Optional header to wait for certain events, such as the creation of a payment method, to occur before returning a response.
     * 
     * <p>When this header is set to `payment-method`, the response will include any payment methods that were created for the newly 
     * linked card in the `paymentMethods` field. Otherwise, the `paymentMethods` field will be omitted from the response.
     */
    public LinkCardRequest withXWaitFor(Optional<? extends LinkCardWaitFor> xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = xWaitFor;
        return this;
    }

    public LinkCardRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public LinkCardRequest withLinkCard(LinkCard linkCard) {
        Utils.checkNotNull(linkCard, "linkCard");
        this.linkCard = linkCard;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkCardRequest other = (LinkCardRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xWaitFor, other.xWaitFor) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.linkCard, other.linkCard);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xWaitFor, accountID, linkCard);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkCardRequest.class,
                "xWaitFor", xWaitFor,
                "accountID", accountID,
                "linkCard", linkCard);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends LinkCardWaitFor> xWaitFor = Optional.empty();

        private String accountID;

        private LinkCard linkCard;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Optional header to wait for certain events, such as the creation of a payment method, to occur before returning a response.
         * 
         * <p>When this header is set to `payment-method`, the response will include any payment methods that were created for the newly 
         * linked card in the `paymentMethods` field. Otherwise, the `paymentMethods` field will be omitted from the response.
         */
        public Builder xWaitFor(LinkCardWaitFor xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = Optional.ofNullable(xWaitFor);
            return this;
        }

        /**
         * Optional header to wait for certain events, such as the creation of a payment method, to occur before returning a response.
         * 
         * <p>When this header is set to `payment-method`, the response will include any payment methods that were created for the newly 
         * linked card in the `paymentMethods` field. Otherwise, the `paymentMethods` field will be omitted from the response.
         */
        public Builder xWaitFor(Optional<? extends LinkCardWaitFor> xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = xWaitFor;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder linkCard(LinkCard linkCard) {
            Utils.checkNotNull(linkCard, "linkCard");
            this.linkCard = linkCard;
            return this;
        }

        public LinkCardRequest build() {

            return new LinkCardRequest(
                xWaitFor, accountID, linkCard);
        }

    }
}
