/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.LinkApplePay;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class LinkApplePayTokenRequest {
    /**
     * ID of the Moov account representing the cardholder.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private LinkApplePay linkApplePay;

    @JsonCreator
    public LinkApplePayTokenRequest(
            String accountID,
            LinkApplePay linkApplePay) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(linkApplePay, "linkApplePay");
        this.accountID = accountID;
        this.linkApplePay = linkApplePay;
    }

    /**
     * ID of the Moov account representing the cardholder.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public LinkApplePay linkApplePay() {
        return linkApplePay;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ID of the Moov account representing the cardholder.
     */
    public LinkApplePayTokenRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public LinkApplePayTokenRequest withLinkApplePay(LinkApplePay linkApplePay) {
        Utils.checkNotNull(linkApplePay, "linkApplePay");
        this.linkApplePay = linkApplePay;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkApplePayTokenRequest other = (LinkApplePayTokenRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.linkApplePay, other.linkApplePay);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, linkApplePay);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LinkApplePayTokenRequest.class,
                "accountID", accountID,
                "linkApplePay", linkApplePay);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private LinkApplePay linkApplePay;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ID of the Moov account representing the cardholder.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder linkApplePay(LinkApplePay linkApplePay) {
            Utils.checkNotNull(linkApplePay, "linkApplePay");
            this.linkApplePay = linkApplePay;
            return this;
        }

        public LinkApplePayTokenRequest build() {

            return new LinkApplePayTokenRequest(
                accountID, linkApplePay);
        }

    }
}
