/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.CreateRefund;
import io.moov.sdk.models.components.TransferWaitFor;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class InitiateRefundRequest {
    /**
     * Prevents duplicate refunds from being created.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-idempotency-key")
    private String xIdempotencyKey;

    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-wait-for")
    private Optional<? extends TransferWaitFor> xWaitFor;

    /**
     * The merchant's Moov account ID.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    /**
     * Identifier for the transfer.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=transferID")
    private String transferID;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private Optional<? extends CreateRefund> createRefund;

    @JsonCreator
    public InitiateRefundRequest(
            String xIdempotencyKey,
            Optional<? extends TransferWaitFor> xWaitFor,
            String accountID,
            String transferID,
            Optional<? extends CreateRefund> createRefund) {
        Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(createRefund, "createRefund");
        this.xIdempotencyKey = xIdempotencyKey;
        this.xWaitFor = xWaitFor;
        this.accountID = accountID;
        this.transferID = transferID;
        this.createRefund = createRefund;
    }
    
    public InitiateRefundRequest(
            String xIdempotencyKey,
            String accountID,
            String transferID) {
        this(xIdempotencyKey, Optional.empty(), accountID,
            transferID, Optional.empty());
    }

    /**
     * Prevents duplicate refunds from being created.
     */
    @JsonIgnore
    public String xIdempotencyKey() {
        return xIdempotencyKey;
    }

    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TransferWaitFor> xWaitFor() {
        return (Optional<TransferWaitFor>) xWaitFor;
    }

    /**
     * The merchant's Moov account ID.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    /**
     * Identifier for the transfer.
     */
    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<CreateRefund> createRefund() {
        return (Optional<CreateRefund>) createRefund;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Prevents duplicate refunds from being created.
     */
    public InitiateRefundRequest withXIdempotencyKey(String xIdempotencyKey) {
        Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
        this.xIdempotencyKey = xIdempotencyKey;
        return this;
    }

    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    public InitiateRefundRequest withXWaitFor(TransferWaitFor xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = Optional.ofNullable(xWaitFor);
        return this;
    }


    /**
     * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
     * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
     */
    public InitiateRefundRequest withXWaitFor(Optional<? extends TransferWaitFor> xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = xWaitFor;
        return this;
    }

    /**
     * The merchant's Moov account ID.
     */
    public InitiateRefundRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    /**
     * Identifier for the transfer.
     */
    public InitiateRefundRequest withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public InitiateRefundRequest withCreateRefund(CreateRefund createRefund) {
        Utils.checkNotNull(createRefund, "createRefund");
        this.createRefund = Optional.ofNullable(createRefund);
        return this;
    }


    public InitiateRefundRequest withCreateRefund(Optional<? extends CreateRefund> createRefund) {
        Utils.checkNotNull(createRefund, "createRefund");
        this.createRefund = createRefund;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InitiateRefundRequest other = (InitiateRefundRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xIdempotencyKey, other.xIdempotencyKey) &&
            Utils.enhancedDeepEquals(this.xWaitFor, other.xWaitFor) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.createRefund, other.createRefund);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xIdempotencyKey, xWaitFor, accountID,
            transferID, createRefund);
    }
    
    @Override
    public String toString() {
        return Utils.toString(InitiateRefundRequest.class,
                "xIdempotencyKey", xIdempotencyKey,
                "xWaitFor", xWaitFor,
                "accountID", accountID,
                "transferID", transferID,
                "createRefund", createRefund);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xIdempotencyKey;

        private Optional<? extends TransferWaitFor> xWaitFor = Optional.empty();

        private String accountID;

        private String transferID;

        private Optional<? extends CreateRefund> createRefund = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Prevents duplicate refunds from being created.
         */
        public Builder xIdempotencyKey(String xIdempotencyKey) {
            Utils.checkNotNull(xIdempotencyKey, "xIdempotencyKey");
            this.xIdempotencyKey = xIdempotencyKey;
            return this;
        }


        /**
         * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
         * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
         */
        public Builder xWaitFor(TransferWaitFor xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = Optional.ofNullable(xWaitFor);
            return this;
        }

        /**
         * Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an 
         * asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
         */
        public Builder xWaitFor(Optional<? extends TransferWaitFor> xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = xWaitFor;
            return this;
        }


        /**
         * The merchant's Moov account ID.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        /**
         * Identifier for the transfer.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder createRefund(CreateRefund createRefund) {
            Utils.checkNotNull(createRefund, "createRefund");
            this.createRefund = Optional.ofNullable(createRefund);
            return this;
        }

        public Builder createRefund(Optional<? extends CreateRefund> createRefund) {
            Utils.checkNotNull(createRefund, "createRefund");
            this.createRefund = createRefund;
            return this;
        }

        public InitiateRefundRequest build() {

            return new InitiateRefundRequest(
                xIdempotencyKey, xWaitFor, accountID,
                transferID, createRefund);
        }

    }
}
