/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.models.components.BankAccountWaitFor;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class InitiateBankAccountVerificationRequest {
    /**
     * Optional header to wait for certain events, such as the rail response, to occur before returning a response.
     * 
     * <p>When this header is set to `rail-response`, the endpoint will wait for a sent-credit or failed status from the payment rail.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-wait-for")
    private Optional<? extends BankAccountWaitFor> xWaitFor;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=bankAccountID")
    private String bankAccountID;

    @JsonCreator
    public InitiateBankAccountVerificationRequest(
            Optional<? extends BankAccountWaitFor> xWaitFor,
            String accountID,
            String bankAccountID) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.xWaitFor = xWaitFor;
        this.accountID = accountID;
        this.bankAccountID = bankAccountID;
    }
    
    public InitiateBankAccountVerificationRequest(
            String accountID,
            String bankAccountID) {
        this(Optional.empty(), accountID, bankAccountID);
    }

    /**
     * Optional header to wait for certain events, such as the rail response, to occur before returning a response.
     * 
     * <p>When this header is set to `rail-response`, the endpoint will wait for a sent-credit or failed status from the payment rail.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<BankAccountWaitFor> xWaitFor() {
        return (Optional<BankAccountWaitFor>) xWaitFor;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String bankAccountID() {
        return bankAccountID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Optional header to wait for certain events, such as the rail response, to occur before returning a response.
     * 
     * <p>When this header is set to `rail-response`, the endpoint will wait for a sent-credit or failed status from the payment rail.
     */
    public InitiateBankAccountVerificationRequest withXWaitFor(BankAccountWaitFor xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = Optional.ofNullable(xWaitFor);
        return this;
    }


    /**
     * Optional header to wait for certain events, such as the rail response, to occur before returning a response.
     * 
     * <p>When this header is set to `rail-response`, the endpoint will wait for a sent-credit or failed status from the payment rail.
     */
    public InitiateBankAccountVerificationRequest withXWaitFor(Optional<? extends BankAccountWaitFor> xWaitFor) {
        Utils.checkNotNull(xWaitFor, "xWaitFor");
        this.xWaitFor = xWaitFor;
        return this;
    }

    public InitiateBankAccountVerificationRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public InitiateBankAccountVerificationRequest withBankAccountID(String bankAccountID) {
        Utils.checkNotNull(bankAccountID, "bankAccountID");
        this.bankAccountID = bankAccountID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InitiateBankAccountVerificationRequest other = (InitiateBankAccountVerificationRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xWaitFor, other.xWaitFor) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.bankAccountID, other.bankAccountID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xWaitFor, accountID, bankAccountID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(InitiateBankAccountVerificationRequest.class,
                "xWaitFor", xWaitFor,
                "accountID", accountID,
                "bankAccountID", bankAccountID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<? extends BankAccountWaitFor> xWaitFor = Optional.empty();

        private String accountID;

        private String bankAccountID;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Optional header to wait for certain events, such as the rail response, to occur before returning a response.
         * 
         * <p>When this header is set to `rail-response`, the endpoint will wait for a sent-credit or failed status from the payment rail.
         */
        public Builder xWaitFor(BankAccountWaitFor xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = Optional.ofNullable(xWaitFor);
            return this;
        }

        /**
         * Optional header to wait for certain events, such as the rail response, to occur before returning a response.
         * 
         * <p>When this header is set to `rail-response`, the endpoint will wait for a sent-credit or failed status from the payment rail.
         */
        public Builder xWaitFor(Optional<? extends BankAccountWaitFor> xWaitFor) {
            Utils.checkNotNull(xWaitFor, "xWaitFor");
            this.xWaitFor = xWaitFor;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder bankAccountID(String bankAccountID) {
            Utils.checkNotNull(bankAccountID, "bankAccountID");
            this.bankAccountID = bankAccountID;
            return this;
        }

        public InitiateBankAccountVerificationRequest build() {

            return new InitiateBankAccountVerificationRequest(
                xWaitFor, accountID, bankAccountID);
        }

    }
}
