/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetWalletTransactionRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=walletID")
    private String walletID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=transactionID")
    private String transactionID;

    @JsonCreator
    public GetWalletTransactionRequest(
            String accountID,
            String walletID,
            String transactionID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(walletID, "walletID");
        Utils.checkNotNull(transactionID, "transactionID");
        this.accountID = accountID;
        this.walletID = walletID;
        this.transactionID = transactionID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String walletID() {
        return walletID;
    }

    @JsonIgnore
    public String transactionID() {
        return transactionID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetWalletTransactionRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetWalletTransactionRequest withWalletID(String walletID) {
        Utils.checkNotNull(walletID, "walletID");
        this.walletID = walletID;
        return this;
    }

    public GetWalletTransactionRequest withTransactionID(String transactionID) {
        Utils.checkNotNull(transactionID, "transactionID");
        this.transactionID = transactionID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetWalletTransactionRequest other = (GetWalletTransactionRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.walletID, other.walletID) &&
            Utils.enhancedDeepEquals(this.transactionID, other.transactionID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, walletID, transactionID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetWalletTransactionRequest.class,
                "accountID", accountID,
                "walletID", walletID,
                "transactionID", transactionID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String walletID;

        private String transactionID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder walletID(String walletID) {
            Utils.checkNotNull(walletID, "walletID");
            this.walletID = walletID;
            return this;
        }


        public Builder transactionID(String transactionID) {
            Utils.checkNotNull(transactionID, "transactionID");
            this.transactionID = transactionID;
            return this;
        }

        public GetWalletTransactionRequest build() {

            return new GetWalletTransactionRequest(
                accountID, walletID, transactionID);
        }

    }
}
