/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetTransferRequest {
    /**
     * Identifier for the transfer.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=transferID")
    private String transferID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;

    @JsonCreator
    public GetTransferRequest(
            String transferID,
            String accountID) {
        Utils.checkNotNull(transferID, "transferID");
        Utils.checkNotNull(accountID, "accountID");
        this.transferID = transferID;
        this.accountID = accountID;
    }

    /**
     * Identifier for the transfer.
     */
    @JsonIgnore
    public String transferID() {
        return transferID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Identifier for the transfer.
     */
    public GetTransferRequest withTransferID(String transferID) {
        Utils.checkNotNull(transferID, "transferID");
        this.transferID = transferID;
        return this;
    }

    public GetTransferRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTransferRequest other = (GetTransferRequest) o;
        return 
            Utils.enhancedDeepEquals(this.transferID, other.transferID) &&
            Utils.enhancedDeepEquals(this.accountID, other.accountID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            transferID, accountID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetTransferRequest.class,
                "transferID", transferID,
                "accountID", accountID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String transferID;

        private String accountID;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Identifier for the transfer.
         */
        public Builder transferID(String transferID) {
            Utils.checkNotNull(transferID, "transferID");
            this.transferID = transferID;
            return this;
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }

        public GetTransferRequest build() {

            return new GetTransferRequest(
                transferID, accountID);
        }

    }
}
