/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class GetTermsOfServiceTokenRequest {
    /**
     * Indicates the domain from which the request originated. Required if referer header is not present.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=origin")
    private Optional<String> origin;

    /**
     * Specifies the URL of the resource from which the request originated. Required if origin header is not present.
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=referer")
    private Optional<String> referer;

    @JsonCreator
    public GetTermsOfServiceTokenRequest(
            Optional<String> origin,
            Optional<String> referer) {
        Utils.checkNotNull(origin, "origin");
        Utils.checkNotNull(referer, "referer");
        this.origin = origin;
        this.referer = referer;
    }
    
    public GetTermsOfServiceTokenRequest() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * Indicates the domain from which the request originated. Required if referer header is not present.
     */
    @JsonIgnore
    public Optional<String> origin() {
        return origin;
    }

    /**
     * Specifies the URL of the resource from which the request originated. Required if origin header is not present.
     */
    @JsonIgnore
    public Optional<String> referer() {
        return referer;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Indicates the domain from which the request originated. Required if referer header is not present.
     */
    public GetTermsOfServiceTokenRequest withOrigin(String origin) {
        Utils.checkNotNull(origin, "origin");
        this.origin = Optional.ofNullable(origin);
        return this;
    }


    /**
     * Indicates the domain from which the request originated. Required if referer header is not present.
     */
    public GetTermsOfServiceTokenRequest withOrigin(Optional<String> origin) {
        Utils.checkNotNull(origin, "origin");
        this.origin = origin;
        return this;
    }

    /**
     * Specifies the URL of the resource from which the request originated. Required if origin header is not present.
     */
    public GetTermsOfServiceTokenRequest withReferer(String referer) {
        Utils.checkNotNull(referer, "referer");
        this.referer = Optional.ofNullable(referer);
        return this;
    }


    /**
     * Specifies the URL of the resource from which the request originated. Required if origin header is not present.
     */
    public GetTermsOfServiceTokenRequest withReferer(Optional<String> referer) {
        Utils.checkNotNull(referer, "referer");
        this.referer = referer;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTermsOfServiceTokenRequest other = (GetTermsOfServiceTokenRequest) o;
        return 
            Utils.enhancedDeepEquals(this.origin, other.origin) &&
            Utils.enhancedDeepEquals(this.referer, other.referer);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            origin, referer);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetTermsOfServiceTokenRequest.class,
                "origin", origin,
                "referer", referer);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> origin = Optional.empty();

        private Optional<String> referer = Optional.empty();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Indicates the domain from which the request originated. Required if referer header is not present.
         */
        public Builder origin(String origin) {
            Utils.checkNotNull(origin, "origin");
            this.origin = Optional.ofNullable(origin);
            return this;
        }

        /**
         * Indicates the domain from which the request originated. Required if referer header is not present.
         */
        public Builder origin(Optional<String> origin) {
            Utils.checkNotNull(origin, "origin");
            this.origin = origin;
            return this;
        }


        /**
         * Specifies the URL of the resource from which the request originated. Required if origin header is not present.
         */
        public Builder referer(String referer) {
            Utils.checkNotNull(referer, "referer");
            this.referer = Optional.ofNullable(referer);
            return this;
        }

        /**
         * Specifies the URL of the resource from which the request originated. Required if origin header is not present.
         */
        public Builder referer(Optional<String> referer) {
            Utils.checkNotNull(referer, "referer");
            this.referer = referer;
            return this;
        }

        public GetTermsOfServiceTokenRequest build() {

            return new GetTermsOfServiceTokenRequest(
                origin, referer);
        }

    }
}
