/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetTerminalConfigurationRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=terminalApplicationID")
    private String terminalApplicationID;

    @JsonCreator
    public GetTerminalConfigurationRequest(
            String accountID,
            String terminalApplicationID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.accountID = accountID;
        this.terminalApplicationID = terminalApplicationID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String terminalApplicationID() {
        return terminalApplicationID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetTerminalConfigurationRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetTerminalConfigurationRequest withTerminalApplicationID(String terminalApplicationID) {
        Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
        this.terminalApplicationID = terminalApplicationID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTerminalConfigurationRequest other = (GetTerminalConfigurationRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.terminalApplicationID, other.terminalApplicationID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, terminalApplicationID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetTerminalConfigurationRequest.class,
                "accountID", accountID,
                "terminalApplicationID", terminalApplicationID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String terminalApplicationID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder terminalApplicationID(String terminalApplicationID) {
            Utils.checkNotNull(terminalApplicationID, "terminalApplicationID");
            this.terminalApplicationID = terminalApplicationID;
            return this;
        }

        public GetTerminalConfigurationRequest build() {

            return new GetTerminalConfigurationRequest(
                accountID, terminalApplicationID);
        }

    }
}
