/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetSweepConfigRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=sweepConfigID")
    private String sweepConfigID;

    @JsonCreator
    public GetSweepConfigRequest(
            String accountID,
            String sweepConfigID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(sweepConfigID, "sweepConfigID");
        this.accountID = accountID;
        this.sweepConfigID = sweepConfigID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String sweepConfigID() {
        return sweepConfigID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetSweepConfigRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetSweepConfigRequest withSweepConfigID(String sweepConfigID) {
        Utils.checkNotNull(sweepConfigID, "sweepConfigID");
        this.sweepConfigID = sweepConfigID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetSweepConfigRequest other = (GetSweepConfigRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.sweepConfigID, other.sweepConfigID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, sweepConfigID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetSweepConfigRequest.class,
                "accountID", accountID,
                "sweepConfigID", sweepConfigID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String sweepConfigID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder sweepConfigID(String sweepConfigID) {
            Utils.checkNotNull(sweepConfigID, "sweepConfigID");
            this.sweepConfigID = sweepConfigID;
            return this;
        }

        public GetSweepConfigRequest build() {

            return new GetSweepConfigRequest(
                accountID, sweepConfigID);
        }

    }
}
