/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetScheduledOccurrenceRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=scheduleID")
    private String scheduleID;

    /**
     * Allows the specification of additional filters beyond the UUID.
     * 
     * <p>Specifying a UUID string returns the exact occurrence.
     * Specifying a RFC 3339 timestamp returns the latest occurrence at or before that timestamp.
     * Specifying `latest` returns the latest occurrence at or before now.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=occurrenceFilter")
    private String occurrenceFilter;

    @JsonCreator
    public GetScheduledOccurrenceRequest(
            String accountID,
            String scheduleID,
            String occurrenceFilter) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(scheduleID, "scheduleID");
        Utils.checkNotNull(occurrenceFilter, "occurrenceFilter");
        this.accountID = accountID;
        this.scheduleID = scheduleID;
        this.occurrenceFilter = occurrenceFilter;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String scheduleID() {
        return scheduleID;
    }

    /**
     * Allows the specification of additional filters beyond the UUID.
     * 
     * <p>Specifying a UUID string returns the exact occurrence.
     * Specifying a RFC 3339 timestamp returns the latest occurrence at or before that timestamp.
     * Specifying `latest` returns the latest occurrence at or before now.
     */
    @JsonIgnore
    public String occurrenceFilter() {
        return occurrenceFilter;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetScheduledOccurrenceRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetScheduledOccurrenceRequest withScheduleID(String scheduleID) {
        Utils.checkNotNull(scheduleID, "scheduleID");
        this.scheduleID = scheduleID;
        return this;
    }

    /**
     * Allows the specification of additional filters beyond the UUID.
     * 
     * <p>Specifying a UUID string returns the exact occurrence.
     * Specifying a RFC 3339 timestamp returns the latest occurrence at or before that timestamp.
     * Specifying `latest` returns the latest occurrence at or before now.
     */
    public GetScheduledOccurrenceRequest withOccurrenceFilter(String occurrenceFilter) {
        Utils.checkNotNull(occurrenceFilter, "occurrenceFilter");
        this.occurrenceFilter = occurrenceFilter;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetScheduledOccurrenceRequest other = (GetScheduledOccurrenceRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.scheduleID, other.scheduleID) &&
            Utils.enhancedDeepEquals(this.occurrenceFilter, other.occurrenceFilter);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, scheduleID, occurrenceFilter);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetScheduledOccurrenceRequest.class,
                "accountID", accountID,
                "scheduleID", scheduleID,
                "occurrenceFilter", occurrenceFilter);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String scheduleID;

        private String occurrenceFilter;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder scheduleID(String scheduleID) {
            Utils.checkNotNull(scheduleID, "scheduleID");
            this.scheduleID = scheduleID;
            return this;
        }


        /**
         * Allows the specification of additional filters beyond the UUID.
         * 
         * <p>Specifying a UUID string returns the exact occurrence.
         * Specifying a RFC 3339 timestamp returns the latest occurrence at or before that timestamp.
         * Specifying `latest` returns the latest occurrence at or before now.
         */
        public Builder occurrenceFilter(String occurrenceFilter) {
            Utils.checkNotNull(occurrenceFilter, "occurrenceFilter");
            this.occurrenceFilter = occurrenceFilter;
            return this;
        }

        public GetScheduledOccurrenceRequest build() {

            return new GetScheduledOccurrenceRequest(
                accountID, scheduleID, occurrenceFilter);
        }

    }
}
