/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetPaymentMethodRequest {

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=paymentMethodID")
    private String paymentMethodID;

    @JsonCreator
    public GetPaymentMethodRequest(
            String accountID,
            String paymentMethodID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.accountID = accountID;
        this.paymentMethodID = paymentMethodID;
    }

    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String paymentMethodID() {
        return paymentMethodID;
    }

    public static Builder builder() {
        return new Builder();
    }


    public GetPaymentMethodRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetPaymentMethodRequest withPaymentMethodID(String paymentMethodID) {
        Utils.checkNotNull(paymentMethodID, "paymentMethodID");
        this.paymentMethodID = paymentMethodID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetPaymentMethodRequest other = (GetPaymentMethodRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.paymentMethodID, other.paymentMethodID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, paymentMethodID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetPaymentMethodRequest.class,
                "accountID", accountID,
                "paymentMethodID", paymentMethodID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String paymentMethodID;

        private Builder() {
          // force use of static builder() method
        }


        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder paymentMethodID(String paymentMethodID) {
            Utils.checkNotNull(paymentMethodID, "paymentMethodID");
            this.paymentMethodID = paymentMethodID;
            return this;
        }

        public GetPaymentMethodRequest build() {

            return new GetPaymentMethodRequest(
                accountID, paymentMethodID);
        }

    }
}
