/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package io.moov.sdk.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.moov.sdk.utils.SpeakeasyMetadata;
import io.moov.sdk.utils.Utils;
import java.lang.Override;
import java.lang.String;


public class GetIssuedCardTransactionRequest {
    /**
     * The Moov business account for which cards have been issued.
     */
    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=accountID")
    private String accountID;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=cardTransactionID")
    private String cardTransactionID;

    @JsonCreator
    public GetIssuedCardTransactionRequest(
            String accountID,
            String cardTransactionID) {
        Utils.checkNotNull(accountID, "accountID");
        Utils.checkNotNull(cardTransactionID, "cardTransactionID");
        this.accountID = accountID;
        this.cardTransactionID = cardTransactionID;
    }

    /**
     * The Moov business account for which cards have been issued.
     */
    @JsonIgnore
    public String accountID() {
        return accountID;
    }

    @JsonIgnore
    public String cardTransactionID() {
        return cardTransactionID;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The Moov business account for which cards have been issued.
     */
    public GetIssuedCardTransactionRequest withAccountID(String accountID) {
        Utils.checkNotNull(accountID, "accountID");
        this.accountID = accountID;
        return this;
    }

    public GetIssuedCardTransactionRequest withCardTransactionID(String cardTransactionID) {
        Utils.checkNotNull(cardTransactionID, "cardTransactionID");
        this.cardTransactionID = cardTransactionID;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetIssuedCardTransactionRequest other = (GetIssuedCardTransactionRequest) o;
        return 
            Utils.enhancedDeepEquals(this.accountID, other.accountID) &&
            Utils.enhancedDeepEquals(this.cardTransactionID, other.cardTransactionID);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountID, cardTransactionID);
    }
    
    @Override
    public String toString() {
        return Utils.toString(GetIssuedCardTransactionRequest.class,
                "accountID", accountID,
                "cardTransactionID", cardTransactionID);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String accountID;

        private String cardTransactionID;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The Moov business account for which cards have been issued.
         */
        public Builder accountID(String accountID) {
            Utils.checkNotNull(accountID, "accountID");
            this.accountID = accountID;
            return this;
        }


        public Builder cardTransactionID(String cardTransactionID) {
            Utils.checkNotNull(cardTransactionID, "cardTransactionID");
            this.cardTransactionID = cardTransactionID;
            return this;
        }

        public GetIssuedCardTransactionRequest build() {

            return new GetIssuedCardTransactionRequest(
                accountID, cardTransactionID);
        }

    }
}
